/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#ifndef SKIN_LIST_ITEM_H
#define SKIN_LIST_ITEM_H


#include "tdelistview.h"


#define MARGIN 3


class TQSimpleRichText;

class SkinListItem : public TDEListViewItem
{
    public:
        explicit SkinListItem(TDEListView* parent, const TQString& fancy_name,
            const TQString& author, const TQPixmap& icon, const TQString& name, const TQString& dir);
        ~SkinListItem();

        void setAuthor(const TQString& author);
        TQString author();

        void setName(const TQString& name);
        TQString name();

        void setDir(const TQString& dir);
        TQString dir();

        void setup();
        void paintCell(TQPainter* p, const TQColorGroup& cg, int column, int width, int align);


    private:
        TQSimpleRichText* item_text;
        TQString skin_name;
        TQString skin_author;
        TQString skin_dir;
};


#endif /* SKIN_LIST_ITEM_H */
