/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXSETTINGSIDSUGGESTIONS_H
#define KBIBTEXSETTINGSIDSUGGESTIONS_H

#include <tqwidget.h>

#include <tdelistview.h>

#include "entry.h"

class TQRegExpValidator;
class TQCheckBox;

class KPushButton;
class KLineEdit;

namespace KBibTeX
{

    class IdSuggestionsListViewItem: public TDEListViewItem
    {
    public:
        IdSuggestionsListViewItem( TDEListView *, const TQString&, BibTeX::Entry *example );
        IdSuggestionsListViewItem( TDEListView *, TDEListViewItem *, const TQString&, BibTeX::Entry *example );
        void setText( int, const TQString& );
        TQString originalText() const;
        int width( const TQFontMetrics &, const TQListView *, int ) const;

    private:
        TQString m_original;
        BibTeX::Entry *m_example;
        TQString parse( const TQString& );
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class SettingsIdSuggestions : public TQWidget
    {
        TQ_OBJECT
    public:
        SettingsIdSuggestions( TQWidget *parent = 0, const char *name = 0 );
        ~SettingsIdSuggestions();

        void applyData();
        void readData();

    signals:
        void configChanged();

    protected slots:
        void slotConfigChanged();

    private slots:
        void slotNewIdSuggestion();
        void slotEditIdSuggestion();
        void slotDeleteIdSuggestion();
        void slotMoveUpIdSuggestion();
        void slotMoveDownIdSuggestion();
        void slotToggleDefault();
        void slotEditSmallWordsChanged( const TQString & );
        void slotAddSmallWord();
        void slotDeleteSmallWord();
        void slotListSmallWordsChanged();
        void updateGUI();

    private:
        TDEListView *m_listIdSuggestions;
        KPushButton *m_buttonNewIdSuggestion;
        KPushButton *m_buttonEditIdSuggestion;
        KPushButton *m_buttonDeleteIdSuggestion;
        KPushButton *m_buttonMoveUpIdSuggestion;
        KPushButton *m_buttonMoveDownIdSuggestion;
        KPushButton *m_buttonToggleDefault;
        TQCheckBox *m_checkBoxForceDefault;
        TDEListView *m_listSmallWords;
        KLineEdit *m_lineEditSmallWords;
        KPushButton *m_buttonAddSmallWord;
        KPushButton *m_buttonDeleteSmallWord;
        TQRegExpValidator *m_validator;
        TQListViewItem *m_defaultSuggestionItem;
        static TQString exampleBibTeXEntry;
        BibTeX::Entry *m_example;

        void setupGUI();
    };

}

#endif
