//
//   File : libkvimircimport.cpp
//   Creation date : Tue Aug 27 01:20:35 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "libkvimircimport.h"
#include "kvi_module.h"

#include "kvi_filedialog.h"
#include "kvi_fileutils.h"
#include "kvi_locale.h"
#include "kvi_config.h"
#include "kvi_app.h"
#include "kvi_qstring.h"


#include <tqmessagebox.h>
#include <tqdir.h>
#include <tqpushbutton.h>
#include "kvi_tal_vbox.h"

KviMircServersIniImport * g_pMircServersIniImport = 0;
KviRemoteMircServersIniImport * g_pRemoteMircServersIniImport = 0;


KviMircServersIniImport::KviMircServersIniImport(KviModuleExtensionDescriptor * d)
: KviMexServerImport(d)
{
}

KviMircServersIniImport::~KviMircServersIniImport()
{
	g_pMircServersIniImport = 0;
}

int KviMircServersIniImport::doImport(const TQString& filename)
{
	KviConfig cfg(filename,KviConfig::Read,true);
	int iCount = 0;
	if(cfg.hasGroup("servers"))
	{
		cfg.setGroup("servers");
		int i = 0;
		TQString key;
		TQString entry;
		do {
			KviTQString::sprintf(key,"n%d",i);
			entry = cfg.readEntry(key,"");
			if(!entry.isEmpty())
			{
				TQString description;
				TQString serv;
				TQString port;
				kvi_u32_t uPort = 0;
				// <description>SERVER:<server:port>GROUP:<network>
				int idx = KviTQString::find(entry,"SERVER:");
				if(idx != -1)
				{
					description = entry.left(idx);
					entry.remove(0,idx + 7);
					idx = KviTQString::find(entry,"GROUP:");
					if(idx != -1)
					{
						port = entry.left(idx);
						entry.remove(0,idx + 6);
					}
					idx = KviTQString::find(port,':');
					if(idx != -1)
					{
						serv = port.left(idx);
						port.remove(0,idx + 1);
						bool bOk;
						uPort = port.toUInt(&bOk);
						if(!bOk)uPort = 6667;
					} else {
						serv = port;
						uPort = 6667;
					}
				}
				if(entry.isEmpty())entry = __tr("Standalone Servers");
				if(!serv.isEmpty())
				{
					KviIrcServer s;
					s.m_szHostname = serv;
					s.m_szDescription = description;
					s.m_uPort = uPort;
					iCount++;
					emit server(s,entry);
				}
				++i;
			}
		} while(!entry.isEmpty());
	} else {
		TQString tmp;
		KviTQString::sprintf(tmp,__tr2qs("%Q doesn't look like a servers.ini file.\nImport failed."),&filename);
		TQMessageBox::warning(0,__tr2qs("Warning - KVIrc"),tmp);
	}
	return iCount;
}

void KviMircServersIniImport::start()
{
	//KviStr buffer;
	TQString buffer;
	if(!KviFileDialog::askForOpenFileName(buffer,__tr("Choose a servers.ini file"),0,"*.ini",false,true))return;

	doImport(buffer);
	delete this;
}

void KviMircServersIniImport::die()
{
	delete this;
}







#define KVI_WWWMIRCCOUK_SERVERSINI "http://www.mirc.co.uk/servers.ini"



KviRemoteMircServerImportWizard::KviRemoteMircServerImportWizard(KviRemoteMircServersIniImport * f)
: KviTalWizard(0)
{
	TQString capt = __tr2qs("Remote mIRC servers.ini Import Wizard");
	setCaption(capt);


	m_pRequest = 0;
	m_pFilter = f;

	TQLabel * l = new TQLabel(this);
	l->setText(__tr2qs("<center><b>Welcome!</b><br><br>This wizard will guide you in the process of " \
			"downloading a list of IRC servers. Please click \"<b>Next</b>\" to begin the operation.</center>"));
	addPage(l,capt);


	KviTalVBox * vb = new KviTalVBox(this);
	l = new TQLabel(vb);
	l->setText(__tr2qs("<center>Here you can modify the URL that the list will be downloaded from. In most cases the default URL is acceptable.</center>"));

	vb->setStretchFactor(l,1);

	m_pUrlEdit = new TQLineEdit(vb);

	m_pUrlEdit->setText(KVI_WWWMIRCCOUK_SERVERSINI);

	addPage(vb,__tr2qs("URL Selection"));

	vb = new KviTalVBox(this);

	l = new TQLabel(__tr2qs("Please wait while the list is being downloaded"),vb);
	vb->setStretchFactor(l,1);

	m_pOutput = new TQLabel(vb);
	m_pOutput->setFrameStyle(TQFrame::WinPanel | TQFrame::Sunken);

	addPage(vb,__tr2qs("List Download"));

	setBackEnabled(vb,false);
	setNextEnabled(vb,false);
	setFinishEnabled(vb,true);

	connect(this,TQ_SIGNAL(selected(const TQString &)),this,TQ_SLOT(pageSelected(const TQString &)));
}

KviRemoteMircServerImportWizard::~KviRemoteMircServerImportWizard()
{
	if(m_pRequest)delete m_pRequest;
}

void KviRemoteMircServerImportWizard::pageSelected(const TQString &title)
{
	if(title == __tr2qs("List Download"))
	{
		start();
	}
}

void KviRemoteMircServerImportWizard::closeEvent(TQCloseEvent *)
{
	m_pFilter->die();
}

void KviRemoteMircServerImportWizard::done(int r)
{
	m_pFilter->die();
}


void KviRemoteMircServerImportWizard::start()
{
	TQString url = m_pUrlEdit->text();
	if(url.isEmpty())url = KVI_WWWMIRCCOUK_SERVERSINI;

	finishButton()->setEnabled(false);
	if(m_pRequest)delete m_pRequest;

	m_pRequest = new KviHttpRequest();
	connect(m_pRequest,TQ_SIGNAL(terminated(bool)),this,TQ_SLOT(getListTerminated(bool)));
	connect(m_pRequest,TQ_SIGNAL(status(const TQString &)),this,TQ_SLOT(getListMessage(const TQString &)));

	g_pApp->getTmpFileName(m_szTmpFileName,"servers.ini");
	if(!m_pRequest->get(KviUrl(url),KviHttpRequest::StoreToFile,m_szTmpFileName))
	{
		delete m_pRequest;
		m_pRequest = 0;
		m_pOutput->setText(__tr2qs("Failed to start the server list transfer :("));
		finishButton()->setEnabled(true);
	}
}

void KviRemoteMircServerImportWizard::getListMessage(const TQString &message)
{
	if(!message.isEmpty())m_pOutput->setText(message);
}


void KviRemoteMircServerImportWizard::getListTerminated(bool bSuccess)
{
	if(!m_pRequest)return;
	if(bSuccess)
	{
		m_pOutput->setText(__tr2qs("File downloaded: processing ..."));
		m_pOutput->repaint();
#ifndef COMPILE_ON_WINDOWS
		g_pApp->syncX();
#endif //!COMPILE_ON_WINDOWS

		int iCount = m_pFilter->doImport(m_szTmpFileName);

		TQString tmp;
		if(iCount > 0)
			tmp = __tr2qs("%1 servers imported succesfully").arg(iCount);
		else
			tmp = __tr2qs("No servers imported");
		m_pOutput->setText(tmp);

		TQDir d;
		d.remove(m_szTmpFileName);
	} else m_pOutput->setText(m_pRequest->lastError());

	delete m_pRequest;
	m_pRequest = 0;
	cancelButton()->setEnabled(false);
	finishButton()->setEnabled(true);
}


KviRemoteMircServersIniImport::KviRemoteMircServersIniImport(KviModuleExtensionDescriptor * d)
: KviMircServersIniImport(d)
{
	m_pWizard = 0;
}

KviRemoteMircServersIniImport::~KviRemoteMircServersIniImport()
{
	if(m_pWizard)delete m_pWizard;
	g_pRemoteMircServersIniImport = 0;
}

void KviRemoteMircServersIniImport::start()
{
	if(m_pWizard)delete m_pWizard;
	m_pWizard = new KviRemoteMircServerImportWizard(this);
	m_pWizard->show();
}

void KviRemoteMircServersIniImport::die()
{
	delete this;
}


static KviModuleExtension * mircimport_local_filter_alloc(KviModuleExtensionAllocStruct * s)
{
	if(g_pMircServersIniImport)delete g_pMircServersIniImport;
	g_pMircServersIniImport = new KviMircServersIniImport(s->pDescriptor);
	return g_pMircServersIniImport;
}

static KviModuleExtension * mircimport_remote_filter_alloc(KviModuleExtensionAllocStruct * s)
{
	if(g_pRemoteMircServersIniImport)delete g_pRemoteMircServersIniImport;
	g_pRemoteMircServersIniImport = new KviRemoteMircServersIniImport(s->pDescriptor);
	return g_pRemoteMircServersIniImport;
}

static bool mircimport_module_init(KviModule * m)
{
	TQString szPath;
	TQPixmap * pix = 0;
	if(g_pApp->findImage(szPath,"kvi_mircimport.png"))
	{
		pix = new TQPixmap(szPath);
		if(pix->isNull())
		{
			delete pix;
			pix = 0;
		}
	}

	KviModuleExtensionDescriptor * d = m->registerExtension("serverimport",
							"mIRC servers.ini import filter",
							__tr("Import from servers.ini"),
							mircimport_local_filter_alloc);

	if(d && pix)d->setIcon(*pix);

	d = m->registerExtension("serverimport",
							"Remote mIRC servers.ini import filter",
							__tr("Import from http://www.mirc.co.uk/servers.ini"),
							mircimport_remote_filter_alloc);

	if(d && pix)d->setIcon(*pix);

	if(pix)delete pix;
	return true;
}

static bool mircimport_module_cleanup(KviModule *m)
{
	if(g_pMircServersIniImport)delete g_pMircServersIniImport;
	if(g_pRemoteMircServersIniImport)delete g_pRemoteMircServersIniImport;
	g_pMircServersIniImport = 0;
	g_pRemoteMircServersIniImport = 0;

	return true;
}

static bool mircimport_module_can_unload(KviModule * m)
{
	return ((!g_pMircServersIniImport) && (!g_pRemoteMircServersIniImport));
}

/*
KVIMODULEEXPORTFUNC KviIrcServerImport * mircimport_module_createIrcServerImport(const char *filterName)
{
	if(kvi_strEqualCI(filterName,__tr("Import from servers.ini")))
	{
		if(!g_pMircServersIniImport)g_pMircServersIniImport = new KviMircServersIniImport();
		return g_pMircServersIniImport;
	} else {
		if(!g_pRemoteMircServersIniImport)g_pRemoteMircServersIniImport = new KviRemoteMircServersIniImport("http://www.mirc.co.uk/servers.ini");
		return g_pRemoteMircServersIniImport;
	}
	return 0;
}
*/



KVIRC_MODULE(
	"File",                                                 // module name
	"1.0.0",                                                // module version
	"Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)", // author & (C)
	"mIRC servers.ini importer",
	mircimport_module_init,
	mircimport_module_can_unload,
	0,
	mircimport_module_cleanup
)

#include "libkvimircimport.moc"
