/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "dependanciesdialog.h"
#include "datablocks/elementlist.h"

#include <tqvbox.h>

#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdeconfig.h>
#include <tdemessagebox.h>

DependanciesDialog::DependanciesDialog( TQWidget *parent, const TQValueList<ListInfo> &lists, bool deps_are_deleted ) : KDialogBase( parent, "DependanciesDialog", true, TQString::null,
	  KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Cancel ),
	  m_depsAreDeleted(deps_are_deleted)
{
	init( lists );
}

DependanciesDialog::DependanciesDialog( TQWidget *parent, const ListInfo &list, bool deps_are_deleted ) : KDialogBase( parent, "DependanciesDialog", true, TQString::null,
	  KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Cancel ),
	  m_depsAreDeleted(deps_are_deleted)
{
	TQValueList<ListInfo> lists;
	lists << list;
	init( lists );
}

DependanciesDialog::~DependanciesDialog()
{}	

void DependanciesDialog::init( const TQValueList<ListInfo> &lists )
{
	TQVBox *page = makeVBoxMainWidget();

	// Design the dialog

	instructionsLabel = new TQLabel( page );
	instructionsLabel->setMinimumSize( TQSize( 100, 30 ) );
	instructionsLabel->setMaximumSize( TQSize( 10000, 10000 ) );
	instructionsLabel->setAlignment( int( TQLabel::WordBreak | TQLabel::AlignVCenter ) );
	
	if ( m_depsAreDeleted ) {
		instructionsLabel->setText( i18n( "<b>WARNING:</b> The following will have to be removed also, since currently they use the element you have chosen to be removed." ) );
	}
	else {
		instructionsLabel->setText( i18n( "<b>WARNING:</b> The following currently use the element you have chosen to be removed." ) );
	}

	for ( TQValueList<ListInfo>::const_iterator list_it = lists.begin(); list_it != lists.end(); ++list_it ) {
		if ( !((*list_it).list).isEmpty() ) {
			TQGroupBox *groupBox = new TQGroupBox( 1, TQt::Vertical, (*list_it).name, page );
			TDEListBox *listBox = new TDEListBox( groupBox );
			loadList( listBox, (*list_it).list );
		}
	}

	setSizeGripEnabled( true );
}

void DependanciesDialog::loadList( TDEListBox* listBox, const ElementList &list )
{
	TDEConfig * config = TDEGlobal::config();
	config->setGroup( "Advanced" );
	bool show_id = config->readBoolEntry( "ShowID", false );

	for ( ElementList::const_iterator el_it = list.begin(); el_it != list.end(); ++el_it ) {
		TQString name = ( *el_it ).name;
		if ( show_id )
			name += " (" + TQString::number(( *el_it ).id) + ")";
		listBox->insertItem( name );
	}
}

void DependanciesDialog::accept()
{
	if ( !m_msg.isEmpty() ) {
		switch ( KMessageBox::warningYesNo(this,
			TQString("<b>%1</b><br><br>%2").arg(m_msg).arg(i18n("Are you sure you wish to proceed?")),
			TQString::null,KStdGuiItem::yes(),KStdGuiItem::no(),"doubleCheckDelete") )
		{
		case KMessageBox::Yes: TQDialog::accept(); break;
		case KMessageBox::No: TQDialog::reject(); break;
		}
	}
	else
		TQDialog::accept();
}
