/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "prog_config_center.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqwidgetstack.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <tqtimer.h>
#include <tqtabwidget.h>
#include <kiconloader.h>

#include "progs/list/prog_list.h"
#include "prog_config_widget.h"
#include "prog_group_ui.h"
#include "libgui/global_config.h"
#include "port_selector.h"
#include "libgui/main_global.h"

//----------------------------------------------------------------------------
TQPixmap Programmer::OptionsConfigWidget::pixmap() const
{
  TDEIconLoader loader;
  return loader.loadIcon("piklab_config_programmer", TDEIcon::Toolbar, TDEIcon::SizeMedium);
}

//----------------------------------------------------------------------------
Programmer::SelectConfigWidget::SelectConfigWidget()
{
  uint row = 0;

// programmer type
  TQLabel *label = new TQLabel(i18n("Programmer in use:"), this);
  addWidget(label, row,row, 0,0);
  _combo = new KeyComboBox<TQString>(this);
  connect(_combo->widget(), TQ_SIGNAL(activated(int)), TQ_SLOT(programmerChanged()));
  addWidget(_combo->widget(), row,row, 1,1);
  row++;

// tab widget
  _tabWidget = new TQTabWidget(this);
  addWidget(_tabWidget, row,row, 0,2);
  row++;

  // port selector
  _portSelectorContainer = new Container;
  _portSelectorContainer->setMargin(10);
  _portSelector = new PortSelector(_portSelectorContainer);
  connect(_portSelector, TQ_SIGNAL(changed()), TQ_SLOT(portChanged()));
  _portSelectorContainer->addWidget(_portSelector, 0,0, 0,0);

  // specific programmer config
  _stack = new KeyWidgetStack<TQString>(_tabWidget);
  static_cast<TQFrame *>(_stack->widget())->setMargin(10);
  TDEIconLoader loader;
  TQPixmap icon = loader.loadIcon("configure", TDEIcon::Small);
  _tabWidget->addTab(_stack->widget(), icon, i18n("Specific"));
  ::Programmer::Lister::ConstIterator it;
  for (it=::Programmer::lister().begin(); it!=::Programmer::lister().end(); ++it) {
    _combo->appendItem(it.key(), it.data()->label());
    ::Programmer::ConfigWidget *pcw = static_cast<const ::Programmer::GroupUI *>(it.data()->gui())->createConfigWidget(_stack->widget());
    pcw->loadConfig();
    _stack->appendItem(it.key(), pcw);
  }

  // init
  _combo->setCurrentItem(GlobalConfig::programmerGroup().name());
  _stack->setCurrentItem(GlobalConfig::programmerGroup().name());
  TQTimer::singleShot(0, this, TQ_SLOT(programmerChanged()));
}

void Programmer::SelectConfigWidget::portChanged()
{
  ::PBusyCursor bc; // can take a few seconds to connect programmer...
  HardwareDescription hd;
  hd.port = _portSelector->portDescription();
  ::Hardware::Config *config = Main::programmerGroup().hardwareConfig();
  if (config) hd.name = config->currentHardware(hd.port.type);
  delete config;
  TQWidget *w = _stack->item(_combo->currentItem());
  bool ok = static_cast< ::Programmer::ConfigWidget *>(w)->setPort(hd);
  _portSelector->setStatus(hd.port.type, ok ? i18n("Connection: Ok") : i18n("Connection: Error"));
}

TQPixmap Programmer::SelectConfigWidget::pixmap() const
{
  TDEIconLoader loader;
  return loader.loadIcon("piklab_config_programmer", TDEIcon::Toolbar, TDEIcon::SizeMedium);
}

void Programmer::SelectConfigWidget::saveConfig()
{
  _portSelector->saveConfig();
  TQString key = _combo->currentItem();
  static_cast<ConfigWidget *>(_stack->item(key))->saveConfig();
  GlobalConfig::writeProgrammerGroup(*::Programmer::lister().group(key));
}

void Programmer::SelectConfigWidget::programmerChanged()
{
  TQString key = _combo->currentItem();
  const ::Programmer::Group &group = *::Programmer::lister().group(key);
  bool isHardware = !group.isSoftware();
  bool hasTab = ( _tabWidget->indexOf(_portSelectorContainer)!=-1 );
  if (isHardware) {
    if ( !hasTab ) {
      TDEIconLoader loader;
      TQPixmap icon = loader.loadIcon("connect_creating", TDEIcon::Small);
      _tabWidget->insertTab(_portSelectorContainer, icon, i18n("Port Selection"), 0);
    }
  } else if (hasTab) _tabWidget->removePage(_portSelectorContainer);
  _portSelector->setGroup(group);
  _stack->setCurrentItem(key);
  if (isHardware) TQTimer::singleShot(0, this, TQ_SLOT(portChanged()));
}

#include "prog_config_center.moc"
