/***************************************************************************
*   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
*   thomas-schweitzer(at)arcor.de                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License version 2.0 as   *
*   published by the Free Software Foundation.                            *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program in the file LICENSE.GPL; if not, write to the *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef UIGUISETTINGS_H
#define UIGUISETTINGS_H

#include <tqmap.h>
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqvariant.h>

class TQSettings;


class UiGuiSettings : public TQObject
{
	TQ_OBJECT

	private:
		UiGuiSettings();

		static UiGuiSettings *m_instance;

	public:
		static UiGuiSettings* getInstance();
		static void           deleteInstance();

		~UiGuiSettings();

		void          loadSettings();
		void          saveSettings();
		bool          setValueByName(const TQString &settingName, TQVariant value);
		TQVariant     getValueByName(const TQString &settingName) const;
		TQStringList& getAvailableTranslations();

	private slots:
		void handleValueChangeFromExtern(bool value);


	signals:
		void recentlyOpenedListSize(int value);
		void loadLastOpenedFileOnStartup(bool value);
		void syntaxHighlightingEnabled(bool value);
		void whiteSpaceIsVisible(bool value);
		void indenterParameterTooltipsEnabled(bool value);
		void tabWidth(int value);
		void language(int value);

	private:
		void emitSignalForSetting(TQString settingName);
		void readAvailableTranslations();

		// Stores the mnemonics of the available translations.
		TQStringList m_availableTranslations;

		// The settings file.
		TQSettings *m_qsettings;

		// This map holds all possible settings defined by their name as TQString.
		TQMap<TQString, TQVariant> m_settings;

		// This map holds the relationship between action widgets and settings entries
		TQMap<TQString, TQString> m_actionSettings;

		// The path where the indenters are located
		TQString m_indenterDirectoryStr;
};

#endif // UIGUISETTINGS_H
