/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ITEMVIEW_H
#define ITEMVIEW_H

#include <view.h>

#include <tqcanvas.h>
#include <tqguardedptr.h>

class CVBEditor;
class ItemDocument;
class TQTimer;

/**
@author David Saxton
*/
class ItemView : public View
{
	Q_OBJECT
  TQ_OBJECT
	public:
		ItemView( ItemDocument *itemDocument, ViewContainer *viewContainer, uint viewAreaId, const char *name = 0 );
		~ItemView();

		virtual bool canZoomIn() const;
		virtual bool canZoomOut() const;
		CVBEditor *cvbEditor() const { return m_CVBEditor; }
		/**
		 * @returns The zoom level
		 */
		double zoomLevel() const { return m_zoomLevel; }

	public slots:
		void actualSize();
		void zoomIn();
		void zoomOut();
		void scrollToMouse( const TQPoint &pos );
		virtual void updateStatus();

	protected slots:
		/**
		 * Called when the user changes the configuration.
		 */
		virtual void slotUpdateConfiguration();
		void startUpdatingStatus();
		void stopUpdatingStatus();

	protected:
		void updateZoomActions();
		/**
		 * Attempts to create a new CNItem if one was dragged onto the canvas
		 */
		void dropEvent( TQDropEvent* );
		/**
		 * Reinherit to allow different types of items to be dragged in.
		 */
		virtual void dragEnterEvent( TQDragEnterEvent* );
		void contentsMousePressEvent( TQMouseEvent *e );
		void contentsMouseReleaseEvent( TQMouseEvent *e );
		void contentsMouseDoubleClickEvent( TQMouseEvent *e );
		void contentsMouseMoveEvent( TQMouseEvent *e );
		void contentsWheelEvent( TQWheelEvent *e );
		void enterEvent( TQEvent * e );
		void leaveEvent( TQEvent * e );

		TQGuardedPtr<ItemDocument> p_itemDocument;
		CVBEditor *m_CVBEditor;
		double m_zoomLevel;
		TQTimer * m_pUpdateStatusTmr;
	
		friend class CVBEditor;
};


/**
@author David Saxton
*/
class CVBEditor : public TQCanvasView
{
Q_OBJECT
  TQ_OBJECT
public:
    CVBEditor( TQCanvas *canvas, ItemView *itemView, const char *name );
	
	void setPassEventsToView( bool pass ) { b_passEventsToView = pass; }

	virtual void contentsMousePressEvent( TQMouseEvent* e );
	virtual void contentsMouseReleaseEvent( TQMouseEvent* e );
	virtual void contentsMouseDoubleClickEvent( TQMouseEvent* e );
	virtual void contentsMouseMoveEvent( TQMouseEvent* e );
	virtual void dragEnterEvent( TQDragEnterEvent* e );
	virtual void dropEvent( TQDropEvent* e );
	virtual void contentsWheelEvent( TQWheelEvent *e );
	virtual void enterEvent( TQEvent * e );
	virtual void leaveEvent( TQEvent * e );

protected:
	virtual void viewportResizeEvent( TQResizeEvent * );
	ItemView *p_itemView;
	bool b_passEventsToView;
	bool b_ignoreEvents;
};



#endif
