/***************************************************************************
 *   Copyright (C) 2003-2004 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PIEDITOR_H
#define PIEDITOR_H

#include <tqwidget.h>
#include <tqstring.h>
#include <tqvariant.h>

class DoubleSpinBox;
class ColorCombo;
class KComboBox;
class KIntSpinBox;
class KLineEdit;
class KURLRequester;
class Variant;


/**
@author Daniel Clarke
*/
class PIEditor : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIEditor(TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PIEditor();
		
	public slots:
		virtual void valueChanged( TQVariant variant );
		
	signals:
		void editorDataChanged(const TQString &id, TQVariant data);
		
	protected:
		TQString m_id;
		Variant *m_data;
};


/**
@author David Saxton
 */
class PIBool : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIBool( TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0 );
		~PIBool();
		
		void popup();
		
	protected slots:
		void selectChanged( int index );
		virtual void valueChanged( TQVariant variant );
		
	protected:
		KComboBox *m_comboBox;
};

/**
@author Daniel Clarke
 */
class PIColor : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIColor(TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PIColor();
		void popup();
		
	protected slots:
		void colorChanged(const TQColor &col);
		virtual void valueChanged( TQVariant variant );
		
	protected:
		ColorCombo *m_combo;
};


/**
Allows the editing of double precision numerical values, using the DoubleNum widget
@author Daniel Clarke
 */
class PIDouble : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIDouble(TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PIDouble();
		
	protected slots:
		void spinValueChanged(double value);
		virtual void valueChanged( TQVariant variant );
		
	protected:
		DoubleSpinBox *spin;
};


/**
@author Daniel Clarke
 */
class PIFilename : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIFilename(TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PIFilename();
		
	protected slots:
		void slotURLChanged(const TQString &url);
		virtual void valueChanged( TQVariant variant );
	// see comments in implementation.
	//void slotOpenFileDialog(KURLRequester *kurlreq);
		
	protected:
		KURLRequester *m_urlreq;
		KComboBox *m_combo;
};

/**
@author David Saxton
 */
class PIInt : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIInt( const TQString &id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PIInt();
	
	protected slots:
		void spinValueChanged( int value );
		virtual void valueChanged( TQVariant variant );
	
	protected:
		KIntSpinBox *spin;
};


/**
@author Daniel Clarke
 */
class PILineEdit : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PILineEdit(TQString id, Variant *data, TQWidget *parent = 0, const char *name = 0);
		~PILineEdit();
		
	protected slots:
		void slotEditTextChanged();
		virtual void valueChanged( TQVariant variant );
		
	protected:
		KLineEdit *m_edit;
};


/**
@author Daniel Clarke
 */
class PIStringCombo : public PIEditor
{
	Q_OBJECT
  TQ_OBJECT
	public:
		PIStringCombo(TQString id, Variant *data, TQWidget *parent, const char *name = 0);
		~PIStringCombo();
		void popup();
		
	public slots:
		virtual void valueChanged( TQVariant variant );
		void slotComboChanged();
		
	protected:
		KComboBox *m_combo;
	
};

#endif
