/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef OSCILLOSCOPEVIEW_H
#define OSCILLOSCOPEVIEW_H

#include <tqframe.h>

class Oscilloscope;
class Simulator;
class TQMouseEvent;
class TQPaintEvent;
class TQPixmap;
class TQTimer;

/**
@author David Saxton
*/
class OscilloscopeView : public TQFrame
{
	Q_OBJECT
  TQ_OBJECT
	public:
		OscilloscopeView( TQWidget *parent, const char *name = 0 );
		virtual ~OscilloscopeView();
		
	public slots:
		/**
		 * Sets the needRedraw flag to true, and then class repaint
		 */
		void updateView();
		void slotSetFrameRate( int fps );
		
	protected slots:
		void updateViewTimeout();
		
	protected:
		virtual void mousePressEvent( TQMouseEvent *event );
		virtual void mouseMoveEvent( TQMouseEvent *event );
		virtual void mouseReleaseEvent( TQMouseEvent *event );
		virtual void paintEvent( TQPaintEvent *event );
		virtual void resizeEvent( TQResizeEvent *event );
		
		void drawLogicData( TQPainter & p );
		void drawFloatingData( TQPainter & p );
		void updateOutputHeight();
		void updateTimeLabel();
		
		bool b_needRedraw;
		TQPixmap *m_pixmap;
		TQTimer *m_updateViewTmr;
		int m_fps;
		int m_sliderValueAtClick;
		int m_clickOffsetPos;
		Simulator * m_pSimulator;
		double m_halfOutputHeight;
};

#endif
