/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

// TDE
#include <kdebug.h>
#include <tdemessagebox.h>

// Portal
#include "request.h"
#include "request.moc"

Request::Request(TQT_DBusConnection connection, const TQT_DBusObjectPath &handle,
                 TQObject *parent, const TQVariant data)
: TQObject(parent),
  m_connection(connection),
  m_handle(handle),
  m_data(data),
  m_registered(false)
{
    if (!m_connection.registerObject(m_handle, this))
    {
        kdWarning() << "Could not register Request object on " << m_handle << endl;
        deleteLater();
        return;
    }
    m_registered = true;
}

Request::~Request()
{
    if (m_registered) m_connection.unregisterObject(m_handle);
}

bool Request::handleMethodCall(const TQT_DBusMessage &message)
{
    if (message.interface() != "org.freedesktop.impl.portal.Request"
     || message.member() != "Close")
    {
        return false;
    }

    TQT_DBusMessage reply = TQT_DBusMessage::methodReply(message);
    m_connection.send(reply);

    emit closeRequested();
    emit closeRequested(m_data);

    deleteLater();
    return true;
}

// kate: replace-tabs true; tab-width 4; indent-width 4;