/***************************************************************************
 *   Copyright (C) 2004 by Paulo Moura Guedes                              *
 *   moura@kdewebdev.org                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef NODULO_H
#define NODULO_H

#include "mstring.h"

#include <tqstring.h>

#include <kdebug.h>
#include <kcharsets.h>

using namespace std;

typedef unsigned int uint;


class Node
{
public:

    enum Element {
        A,
        AREA,
        LINK,
        META,
        IMG,
        FRAME,
        BASE,
        TITLE
    };
    enum LinkType {
        href,
        file_href,
        mailto,
        relative
    };

    Node();
    Node(TQString const& content);
    virtual ~Node();

    TQString getAttribute(TQString const& atributo);
    virtual TQString const& url() const = 0;
    virtual TQString const& linkLabel() const = 0; // URL label
    virtual void setNode(TQString const& content);
    virtual void parse() = 0;
    void setMalformed(bool flag = true);
    virtual void setLinkType(LinkType const& lt);

    TQString const& content() const;
    bool malformed() const;
    LinkType linkType() const;
    Element element() const;
    virtual bool isLink() const = 0;

    bool isRedirection() const;

protected:

    Element element_;
    LinkType linktype_;
    TQString link_label_;
    TQString content_;
    bool is_redirection_;
    bool malformed_;
};


class NodeLink: public Node
{
public:
    NodeLink();
    NodeLink(TQString const& content);
    ~NodeLink()
    {}
    ;

    virtual void parse();

    virtual TQString const& url() const;
    virtual TQString const& linkLabel() const; // URL label
    virtual TQString mailto() const;
    virtual bool isLink() const;

private:
    virtual void parseAttributeHREF();
    void parseLinkLabel();

private:
    TQString attribute_href_;
};

class NodeA: public NodeLink
{
public:
    NodeA(TQString const& content);
    ~NodeA()
    {}
    ;
    TQString const& attributeNAME() const;

    virtual void parse();

private:
    void parseAttributeNAME();

private:
    TQString attribute_name_;
};

class NodeAREA: public NodeLink
{
public:
    NodeAREA(TQString const& content);
    ~NodeAREA() {};
    
    TQString const& attributeTITLE() const;

    virtual void parse();

private:
    void parseAttributeTITLE();

private:
    TQString attribute_title_;
};


class NodeLINK: public NodeLink
{
public:
    NodeLINK(TQString const& content);
    ~NodeLINK()
    {}
    ;
};

class NodeMETA: public Node
{
public:
    NodeMETA();
    NodeMETA(TQString const& content);
    ~NodeMETA()
    {}
    ;

    virtual TQString const& url() const;
    virtual const TQString& linkLabel() const;
    virtual bool isLink() const;
    TQString const& atributoHTTP_EQUIV() const;
    TQString const& atributoNAME() const;
    TQString const& atributoCONTENT() const;
    TQString charset() const;
    bool isRedirection() const;

    virtual void parse();

private:
    /**
       Procura se existem os atributos HTTP-EQUIV=Refresh e URL=...
       Se existir considera o content do atributo URL como um link.
       ex: <META HTTP-EQUIV=Refresh CONTENT="10; URL=http://www.htmlhelp.com/">
    */
    void parseAttributeURL();

    void parseAttributeHTTP_EQUIV();
    void parseAttributeNAME();
    void parseAttributeCONTENT();

private:
    TQString attribute_http_equiv_;
    TQString attribute_url_;
    TQString attribute_name_;
    TQString attribute_content_;
};

class NodeIMG: public Node
{
public:
    NodeIMG(TQString const& content);
    ~NodeIMG()
    {}
    ;

    virtual void parse();

    virtual TQString const& url() const;
    virtual TQString const& linkLabel() const; // Image label
    virtual bool isLink() const;

private:
    void parseAttributeSRC();
    void parseAttributeTITLE();
    void parseAttributeALT();

private:
    TQString attribute_src_;
    TQString attribute_title_;
    TQString attribute_alt_;
};

class NodeFRAME: public Node
{
public:
    NodeFRAME(TQString const& content);
    ~NodeFRAME()
    {}
    ;

    virtual void parse();
    virtual TQString const& url() const;
    virtual TQString const& linkLabel() const;
    virtual bool isLink() const;

private:
    void parseAttributeSRC();

private:
    TQString attribute_src_;
};

class NodeBASE: public NodeLink
{
public:
    NodeBASE();
    NodeBASE(TQString const& content);
    ~NodeBASE()
    {}
    ;

    virtual bool isLink() const;
};

class NodeTITLE: public Node
{
public:
    NodeTITLE();
    NodeTITLE(TQString const& content);
    ~NodeTITLE()
    {}
    ;

    virtual TQString const& url() const;
    virtual TQString const& linkLabel() const;
    virtual void parse();
    virtual bool isLink() const;
    
    TQString const& attributeTITLE() const;

private:
    void parseAttributeTITLE();

private:
    TQString attribute_title_;
};


#include "node_impl.h"

#endif
