/***************************************************************************
                          filestreeview.cpp  -  description
                             -------------------
    begin                : Thu Jun 1 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon <pdima@users.sourceforge.net,yshurik@linuxfan.com,sequitur@easystreet.com>
                           (C) 2001-2004 Andras Mantia <amantoa@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// TQt includes
#include <tqpainter.h>

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <kopenwith.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <tdefiledialog.h>
#include <kprogress.h>
#include <kurl.h>

// app includes
#include "servertreeview.h"
#include "resource.h"
#include "project.h"
#include "qextfileinfo.h"


ServerTreeViewItem::ServerTreeViewItem( KFileTreeViewItem *parent, KFileItem* item, KFileTreeBranch *brnch )
: BaseTreeViewItem( parent, item, brnch)
{
}

void ServerTreeViewItem::paintCell(TQPainter *p, const TQColorGroup &cg,
                                   int column, int width, int align)
{
  TQColorGroup _cg( cg );
  KURL baseURL = Project::ref()->projectBaseURL();
  KURL relURL = baseURL;
  relURL.setPath(QExtFileInfo::toRelative(url(), branch()->url()).path());
  KURL url = QExtFileInfo::toAbsolute(relURL, baseURL);
  if ( !Project::ref()->contains(url) )
  {
    TQFont f = p->font();
    f.setItalic(true);
    p->setFont(f);
    int h, s, v;
    p->pen().color().getHsv(&h, &s, &v);
    v = (v < 155 ? v + 100 : 255);
    _cg.setColor(TQColorGroup::Text, TQColor(h, s, v, TQColor::Hsv));
  };
  BaseTreeViewItem::paintCell( p, _cg, column, width, align );
}

//ServerTreeBranch implementation
ServerTreeBranch::ServerTreeBranch(KFileTreeView *parent, const KURL& url,
                                   const TQString& name, const TQPixmap& pix,
                                   bool showHidden, KFileTreeViewItem *branchRoot)
    : BaseTreeBranch(parent, url, name, pix, showHidden, branchRoot)
{
}

KFileTreeViewItem* ServerTreeBranch::createTreeViewItem(KFileTreeViewItem *parent, KFileItem *fileItem )
{
  BaseTreeViewItem  *tvi = 0;
  if( parent && fileItem )
  {
    tvi = new ServerTreeViewItem( parent, fileItem, this );
  }
  else
    kdDebug(24000) << "ServerTreeBranch::createTreeViewItem: Have no parent" << endl;
  return tvi;
}

/////////////////////////////////////////////////////////////////////////////////////
//
// ServerTreeView implementation
//
//
ServerTreeView::ServerTreeView(TDEConfig *config, TQWidget *parent, const KURL &url, const char *name)
  : BaseTreeView(parent, name)
{
  setAcceptDrops(true);
  setDragEnabled(true);

  m_config = config;
  m_config->setGroup("General Options");
  // I must read this here because quanta_init has not done it yet
  qConfig.showHiddenFiles = m_config->readBoolEntry("Show Hidden Files", true);

  m_fileMenu = new TDEPopupMenu();

  m_fileMenu->insertItem(SmallIcon("document-open"), i18n("&Open"), this ,TQ_SLOT(slotOpen()));
  m_fileMenu->insertItem(i18n("Open &With..."), this, TQ_SLOT(slotOpenWith()));
  m_menuClose = m_fileMenu->insertItem(SmallIcon("window-close"), i18n("Clos&e"), this, TQ_SLOT(slotClose()));
  m_fileMenu->insertSeparator();
//  m_insertFileInProject = m_fileMenu->insertItem(i18n("&Insert in Project..."), this, TQ_SLOT(slotInsertInProject()));
  m_fileMenu->insertItem(SmallIcon("edit-copy"), i18n("&Copy"), this, TQ_SLOT(slotCopy()));
  m_fileMenu->insertItem(SmallIcon("edit-delete"), i18n("&Delete"), this, TQ_SLOT(slotDelete()));
  m_fileMenu->insertItem(i18n("Re&name"), this, TQ_SLOT(slotStartRename()));
  m_fileMenu->insertSeparator();
  m_fileMenu->insertItem(SmallIcon("application-vnd.tde.info"), i18n("&Properties"), this, TQ_SLOT(slotProperties()));

  m_folderMenu = new TDEPopupMenu();

//  m_insertFolderInProject = m_folderMenu->insertItem(i18n("&Insert in Project..."), this, TQ_SLOT(slotInsertDirInProject()));
  m_folderMenu->insertItem(SmallIcon("edit-copy"), i18n("&Copy"), this, TQ_SLOT(slotCopy()));
  m_menuPasteFolder = m_folderMenu->insertItem(SmallIcon("edit-paste"), i18n("&Paste"), this, TQ_SLOT(slotPaste()));
  m_menuDel = m_folderMenu->insertItem( SmallIcon("edit-delete"), i18n("&Delete"), this, TQ_SLOT(slotDelete()));
  m_renameId = m_folderMenu->insertItem(i18n("Re&name"), this, TQ_SLOT(slotStartRename()));
  m_folderMenu->insertSeparator();
  m_folderMenu->insertItem(SmallIcon("application-vnd.tde.info"), i18n("&Properties"), this, TQ_SLOT(slotProperties()));
  m_reloadMenuId = m_folderMenu->insertItem(SmallIcon("document-revert"), i18n("&Reload"), this, TQ_SLOT(slotReload()));

  addColumn(i18n("Upload Tree"), -1);
  addColumn("");

  connect(this, TQ_SIGNAL(open(TQListViewItem *)),
          this, TQ_SLOT(slotSelectFile(TQListViewItem *)));
  connect(this, TQ_SIGNAL(contextMenu(TDEListView*, TQListViewItem*, const TQPoint&)),
          this, TQ_SLOT(slotMenu(TDEListView*, TQListViewItem*, const TQPoint&)));
  connect(Project::ref(), TQ_SIGNAL(reloadTree(ProjectList *, bool, const TQStringList &)),
          this, TQ_SLOT(slotReloadTree(ProjectList *, bool, const TQStringList &)));

  restoreLayout(m_config, "UploadTreeView");  // a fixed name only for the tooltip configuration
  // the restored size of the first column might be too large for the current content
  // we set it to 10 and the listview will adjust it to the size of the largest entry
  setColumnWidth(0, 10);
  newBranch(url);
}

ServerTreeView::~ServerTreeView()
{
}

KFileTreeBranch* ServerTreeView::newBranch(const KURL& url)
{
  KURL branchURL = url;
  branchURL.adjustPath(+1);
  BaseTreeBranch* newBrnch = 0;
  newBrnch = new ServerTreeBranch(this, branchURL, branchURL.prettyURL(), SmallIcon("go-up"), true);
  newBrnch->setShowingDotFiles(qConfig.showHiddenFiles);
  addBranch(newBrnch);
  return newBrnch;
}


/** RMB pressed, bring up the menu */
void ServerTreeView::slotMenu(TDEListView* listView, TQListViewItem *item, const TQPoint &point)
{
  Q_UNUSED(listView);
  if (item)
  {
    setSelected(item, true);
    KFileTreeViewItem *curItem = currentKFileTreeViewItem();
    if ( !curItem->isDir() )
    {
      m_fileMenu->setItemVisible(m_menuClose, isFileOpen(currentURL()));
      m_fileMenu->popup(point);
    } else {
      m_folderMenu->setItemVisible(m_menuPasteFolder, isPathInClipboard());
      bool root = (curItem == curItem->branch()->root());
      m_folderMenu->setItemVisible(m_menuDel, ! root);
      m_folderMenu->setItemVisible(m_reloadMenuId, root);
      m_folderMenu->setItemVisible(m_renameId, ! root);
      m_folderMenu->popup(point);
   }
 }
}


void ServerTreeView::slotReloadTree( ProjectList *fileList, bool buildNewTree, const TQStringList &folderToOpen)
{
  Q_UNUSED(fileList);
  Q_UNUSED(buildNewTree);
  Q_UNUSED(folderToOpen);
  
  TQListViewItemIterator iter(this);
  for ( ; iter.current(); ++iter )
  {
    iter.current()->repaint();
  }
}

#include "servertreeview.moc"
