/***************************************************************************
 *   Copyright (C) 2004 by ian reinhart geiser                             *
 *   geiseri@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef __DISTPART_WIDGET_H__
#define __DISTPART_WIDGET_H__


#include <tqwidget.h>
#include <tqstring.h>
#include "distpart_ui.h"
#include <tdelistbox.h>
#include <tqcheckbox.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <tqcombobox.h>
#include <tqprogressbar.h>

class KDevProject;
class DistpartPart;
class TQUrlOperator;
class TDEProcess;
class TQTabWidget;
class SpecSupport;

namespace KParts {
class ReadOnlyPart;
}


class DistpartDialog : public distpart_ui {
    TQ_OBJECT
  

public:

    DistpartDialog(DistpartPart *part, TQWidget *parent);
    ~DistpartDialog();

signals:
    void okay();
    void cancel();
    void help();
    void createsrc();
    void resetsrc();
    void buildall();
    void savespec();
    void loadspec();
    void srcrpm();
    void genhtml();
    void resethtml();
    void upload();
    void resetupload();

    // Accessors and mutators to control GUI
    // Connect Slots to the following widgets


public slots:
    //    TQPushButton* okayPushButton;


    void slotokayPushButtonPressed();
    //    TQPushButton* cancelPushButton;
    void slotcancelPushButtonPressed();
    //    TQPushButton* help_PushButton;
//    void slothelp_PushButtonPressed();
    //    TQPushButton* createSrcArchPushButton;
    void slotcreateSrcArchPushButtonPressed();
    //    TQPushButton* resetSrcPushButton;
    void slotresetSrcPushButtonPressed();

    //    TQPushButton* genHTMLPushButton;
    void slotgenHTMLPushButtonPressed();
    //    TQPushButton* resetHTMLPushButton;
    void slotresetHTMLPushButtonPressed();
    //    TQToolButton* uploadAddFileToolButton;
    void slotuploadAddFileToolButtonPressed();
    //    TQToolButton* uploadRemoveToolButton;
    void slotuploadRemoveToolButtonPressed();
    //    TQPushButton* uploadSubmitPushButton;
    void slotuploadSubmitPushButtonPressed();
    //    TQPushButton* uploadResetPushButton;
    void slotuploadResetPushButtonPressed();

    // Connect Slots to the following widgets and add
    // accessors and mutators
    //    TQCheckBox* customProjectCheckBox;
    void slotcustomProjectCheckBoxChanged();
    //  TQCheckBox* uploadCustomCheckBox;
    void slotuploadCustomCheckBoxChanged();

    void slotbuildAllPushButtonPressed();
    void slotexportSPECPushButtonPressed();
    void slotimportSPECPushButtonPressed();
    void slotsrcPackagePushButtonPressed();
	void slotAddFileButtonPressed();
	void slotRemoveFile(TQListBoxItem *item);

public:
    bool getcustomProjectCheckBoxState();
    void setcustomProjectCheckBoxState(bool state);
    bool getuploadCustomCheckBoxState();
    void setuploadCustomCheckBoxState(bool state);

    // Add accessors and mutators for the following

    //   TQCheckBox* bzipCheckBox;
    bool getbzipCheckBoxState();
    void setbzipCheckBoxState(bool state);
    //    TQCheckBox* appIconCheckBox;
    bool getappIconCheckBoxState();
    void setappIconCheckBoxState(bool state);
    //    TQCheckBox* genHTMLCheckBox;
    bool getgenHTMLCheckBoxState();
    void setgenHTMLCheckBoxState(bool state);
    //    TQCheckBox* useRPMInfoCheckBox;
    bool getuseRPMInfoCheckBoxState();
    void setuseRPMInfoCheckBoxState(bool state);
    //    TQCheckBox* uploadAppsKDEcomCheckBox;
    bool getuploadAppsKDEcomCheckBoxState();
    void setuploadAppsKDEcomCheckBoxState(bool state);
    //    TQCheckBox* uploadftpkdeorgCheckBox;
    bool getuploadftpkdeorgCheckBoxState();
    void setuploadftpkdeorgCheckBoxState(bool state);
    //    TQCheckBox* devPackageCheckBox;
    bool getdevPackageCheckBoxState();
    void setdevPackageCheckBoxState(bool state);
    //    TQCheckBox* docsPackageCheckBox;
    bool getdocsPackageCheckBoxState();
    void setdocsPackageCheckBoxState(bool state);
    //    TQLineEdit* archNameFormatLineEdit;
    TQString getarchNameFormatLineEditText();
    void setarchNameFormatLineEditText(TQString text);
    //    TQLineEdit* appNameLineEdit;
    TQString getappNameFormatLineEditText();
    void setappNameFormatLineEditText(TQString text);
    //    TQLineEdit* summaryLineEdit;
    TQString getsummaryLineEditText();
    void setsummaryLineEditText(TQString text);
    //    TQLineEdit* groupLineEdit;
    TQString getgroupLineEditText();
    void setgroupLineEditText(TQString text);
    //    TQLineEdit* releaseLineEdit;
    TQString getreleaseLineEditText();
    void setreleaseLineEditText(TQString text);
    //    TQLineEdit* VersionLineEdit;
    TQString getversionLineEditText();
    void setversionLineEditText(TQString text);
    //    TQLineEdit* VendorLineEdit;
    TQString getvendorLineEditText();
    void setvendorLineEditText(TQString text);
    //    TQLineEdit* LicenseLineEdit;
    TQString getlicenseLineEditText();
    void setlicenseLineEditText(TQString text);
    //    TQLineEdit* uploadURLLineEdit;
    TQString getuploadURLLineEditText();
    void setuploadURLLineEditText(TQString text);
    //    TQLineEdit* PackagerLineEdit;
    TQString getpackagerLineEditText();
    void setpackagerLineEditText(TQString text);
    //    TQComboBox* archComboBox;
    TQString getarchComboBoxText();
    int getarchComboBoxItem();
    void setarchComboBoxItem(int item);
    //    TQListBox* uploadFileListBox;
    TQString getuploadFileListBoxText();
    int getuploadFileListBoxItem();
    void setuploadFileListBoxItem(int item);
    //    TQListBox* srcDistFileListBox;
    TQString getsrcDistFileListBoxText();
    int getsrcDistFileListBoxItem();
    void setsrcDistFileListBoxItem(int item);
    //    TQMultiLineEdit* projectDescriptionMultilineEdit;
    TQString getprojectDescriptionMultilineEditText();
    void setprojectDescriptionMultilineEditText(TQString text);

    TQString getprojectChangelogMultilineEditText();
    void setprojectChangelogMultilineEditText(TQString text);

    TQString getSourceName();

private:
    void loadSettings();
    void storeSettings();
    void setPackageData();
    void getPackageData();

    SpecSupport *m_spec;
    DistpartPart *m_part;
    TQString dir;
};


#endif
