#ifndef INC_MismatchedCharException_hpp__
#define INC_MismatchedCharException_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

#include "antlr/config.h"
#include "antlr/RecognitionException.h"
#include "antlr/BitSet.h"
#include "antlr/CharScanner.h"

ANTLR_BEGIN_NAMESPACE(antlr)

class MismatchedCharException : public RecognitionException {
public:
	// Types of chars
#ifndef NO_STATIC_CONSTS
	static const int CHAR = 1;
	static const int NOT_CHAR = 2;
	static const int RANGE = 3;
	static const int NOT_RANGE = 4;
	static const int SET = 5;
	static const int NOT_SET = 6;
#else
	enum {
		CHAR = 1,
		NOT_CHAR = 2,
		RANGE = 3,
		NOT_RANGE = 4,
		SET = 5,
		NOT_SET = 6
	};
#endif

public:
	// One of the above
	int mismatchType;

	// what was found on the input stream
	int foundChar;

	// For CHAR/NOT_CHAR and RANGE/NOT_RANGE
	int expecting;

	// For RANGE/NOT_RANGE (expecting is lower bound of range)
	int upper;

	// For SET/NOT_SET
	BitSet set;

protected:
	// who knows...they may want to ask scanner questions
	CharScanner* scanner;

public:
	MismatchedCharException();

	// Expected range / not range
	MismatchedCharException(
		int c,
		int lower,
		int upper_,
		bool matchNot,
		CharScanner* scanner_
	);

	// Expected token / not token
	MismatchedCharException(
		int c,
		int expecting_,
		bool matchNot,
		CharScanner* scanner_
	);

	// Expected BitSet / not BitSet
	MismatchedCharException(
		int c,
		BitSet set_,
		bool matchNot,
		CharScanner* scanner_
	);

	MismatchedCharException(
		const ANTLR_USE_NAMESPACE(std)string& s,
		int line
	);
	~MismatchedCharException() throw() {}

	/**
	 * Returns the error message that happened on the line/col given.
	 * Copied from toString().
	 */
	ANTLR_USE_NAMESPACE(std)string getMessage() const;
};

ANTLR_END_NAMESPACE

#endif //INC_MismatchedCharException_hpp__
