/***************************************************************************
                                kompareprocess.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2003 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef KOMPAREPROCESS_H
#define KOMPAREPROCESS_H

#include <tdeprocess.h>

#include "kompare.h"

class TQTextCodec;

class DiffSettings;

class KompareProcess : public TDEProcess, public KompareFunctions
{
	TQ_OBJECT
  

public:
	KompareProcess( DiffSettings* diffSettings, enum Kompare::DiffMode mode, TQString source, TQString destination, TQString directory = TQString() );
	~KompareProcess();

	bool start();

	TQString diffOutput() { return m_stdout; }
	TQString stdOut()     { return m_stdout; }
	TQString stdErr()     { return m_stderr; }

	void setEncoding( const TQString& encoding );

signals:
	void diffHasFinished( bool finishedNormally );

protected:
	void writeDefaultCommandLine();
	void writeCommandLine();

protected slots:
	void slotReceivedStdout( TDEProcess*, char*, int );
	void slotReceivedStderr( TDEProcess*, char*, int );
	void slotProcessExited( TDEProcess* proc );

private:
	DiffSettings*          m_diffSettings;
	enum Kompare::DiffMode m_mode;
	TQString                m_stdout;
	TQString                m_stderr;
	TQTextDecoder*          m_textDecoder;
};

#endif
