//
// C++ Interface: chunk
//
// Description: 
//
//
// Author: Andrea Rizzi <rizzi@kde.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef DBSE2_CHUNK_H
#define DBSE2_CHUNK_H
#include <tqstring.h>
#include <tqvaluelist.h>
#include "database.h"

/**
  * Abstract class for text chunks. 
  * Examples of chunks are "Words" or "Sentences"
  * This abstraction allow to use generic algorithm on chunks,
  * like chunkByChunk translation or chunk indexing.
  */
class AbstractChunk
{
    public:
    AbstractChunk(DataBaseInterface *_di) {di=_di;}
    virtual ~AbstractChunk();
    /**
      * This function should return a list of translation for the current chunk.
      */
    virtual TQValueList<QueryResult> translations()=0;
    
    //FIXME: is this in the right place, better in factory? check that stuff
    //virtual TQValueList<QueryResult> translationsFromReference(uint reference)=0;
    virtual TQValueList<uint> locationReferences()=0;
    virtual void setLocationReferences(TQValueList<uint>)=0;
    virtual TQString chunkString()=0;
    
    protected:
    DataBaseInterface *di;
};

/**
  * Concrete impl of Chunk, in this case chunks are words.
  */
class WordChunk : public AbstractChunk
{
    public:
    WordChunk(DataBaseInterface *di,TQString _word);
    virtual TQValueList<QueryResult> translations();
    //virtual TQValueList<QueryResult> translationsFromReference(uint reference);
    virtual TQValueList<uint> locationReferences();
    virtual void setLocationReferences(TQValueList<uint>);
    virtual TQString chunkString(){return word;}

    //static TQValueList<WordChunk> divide(TQString);
    private:
    TQString word;
};

/**
  * Concrete impl of Chunk, in this case chunks are sentences.
  */
class SentenceChunk : public AbstractChunk
{
    public:
    SentenceChunk(DataBaseInterface *di,TQString _sentence);
    virtual TQValueList<QueryResult> translations();
    //virtual TQValueList<QueryResult> translationsFromReference(uint reference);
    virtual TQValueList<uint> locationReferences();
    virtual void setLocationReferences(TQValueList<uint>);
    virtual TQString chunkString(){return sentence;}

   // static TQValueList<SentenceChunk> divide(TQString);
    
    private:
    TQString sentence;    
};


/**********************************
  CHUNK FACTORIES
**********************************/


class AbstractChunkFactory 
{
  public:
    AbstractChunkFactory(DataBaseInterface *_di)
    {
	di=_di;
    }
    virtual ~AbstractChunkFactory(){}
    virtual  TQPtrList<AbstractChunk> chunks()=0;
    /**
      Change th string and return the chunks
      */
    virtual  TQPtrList<AbstractChunk> chunks(const TQString& s)
    {
	string=s;
	return chunks();
    }
    /**
      * Returns the list of separators of last @ref chunks() call
      */
    
    virtual  TQStringList separators(){ return _separators;}
    void setQuery(const TQString& s)
    {
	string=s;
    }
  protected:
    TQString string;
    TQStringList _separators;
    DataBaseInterface *di;
};

class WordChunkFactory : public AbstractChunkFactory
{
  public:
    WordChunkFactory(DataBaseInterface *_di);
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  TQPtrList<AbstractChunk> chunks();
};

class CaseBasedWordChunkFactory : public AbstractChunkFactory
{
  public:
    CaseBasedWordChunkFactory(DataBaseInterface *_di);
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  TQPtrList<AbstractChunk> chunks();
};

class SentenceChunkFactory : public AbstractChunkFactory
{
  public:
    SentenceChunkFactory(DataBaseInterface *_di);
    
    /**
      YOU SHOULD DELETE THE CHUNKS!!
      */
    virtual  TQPtrList<AbstractChunk> chunks();
};


#endif //_CHUNK_H_
