/*
    This file is part of tdepim.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>

#include <tdeaccelmanager.h>
#include <kdialog.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "wizards-config.h"
#include "egroupwarewizard.h"
#include "kolabwizard.h"
#include "sloxwizard.h"
#include "exchangewizard.h"

#include "overviewpage.h"

OverViewPage::OverViewPage( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  TQGridLayout *layout = new TQGridLayout( this, 7, 4, KDialog::marginHint(),
                                         KDialog::spacingHint() );

  const TQString msg = i18n( "TDE Groupware Wizard" );
  TQLabel *label = new TQLabel( "<qt><b><u><h2>" + msg + "</h2></u></b></qt>" , this );
  layout->addMultiCellWidget( label, 0, 0, 0, 2 );

  label = new TQLabel( this );
  label->setPixmap( TDEGlobal::iconLoader()->loadIcon( "network", TDEIcon::Desktop ) );
  layout->addWidget( label, 0, 3 );

  label = new TQLabel( "", this );
  layout->addWidget( label, 1, 0 );
  layout->setRowSpacing( 1, 20 );

  label = new TQLabel( i18n( "Select the type of server you want TDE to connect:" ), this );
  layout->addMultiCellWidget( label, 2, 2, 0, 3 );

  TQPushButton *button;

#ifdef WITH_EGROUPWARE
  button = new TQPushButton( i18n("eGroupware"), this );
  layout->addMultiCellWidget( button, 3, 3, 0, 3 );
  connect( button, TQ_SIGNAL( clicked() ), TQ_SLOT( showWizardEGroupware() ) );
#endif

  // FIXME: Maybe hyperlinks would be better than buttons.

#ifdef WITH_KOLAB
  button = new TQPushButton( i18n("Kolab"), this );
  layout->addMultiCellWidget( button, 4, 4, 0, 3 );
  connect( button, TQ_SIGNAL( clicked() ), TQ_SLOT( showWizardKolab() ) );
#endif

#ifdef WITH_SLOX
  button = new TQPushButton( i18n("SUSE Linux Openexchange (SLOX)"), this );
  layout->addMultiCellWidget( button, 5, 5, 0, 3 );
  connect( button, TQ_SIGNAL( clicked() ), TQ_SLOT( showWizardSlox() ) );
#endif

#ifdef WITH_NEWEXCHANGE
  button = new TQPushButton( i18n("Microsoft Exchange"), this );
  button->hide(); // not quite ready yet
  layout->addMultiCellWidget( button, 6, 6, 0, 3 );
  connect( button, TQ_SIGNAL( clicked() ), TQ_SLOT( showWizardExchange() ) );
#endif

  TQFrame *frame = new TQFrame( this );
  frame->setFrameStyle( TQFrame::HLine | TQFrame::Sunken );
  layout->addMultiCellWidget( frame, 7, 7, 0, 3 );

  TQPushButton *cancelButton = new KPushButton( KStdGuiItem::close(), this );
  layout->addWidget( cancelButton, 8, 3 );

  connect( cancelButton, TQ_SIGNAL( clicked() ), this, TQ_SIGNAL( cancel() ) );

  layout->setRowStretch( 7, 1 );

  TDEAcceleratorManager::manage( this );
}

OverViewPage::~OverViewPage()
{
}

void OverViewPage::showWizardEGroupware()
{
#ifdef WITH_EGROUPWARE
  EGroupwareWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardKolab()
{
#ifdef WITH_KOLAB
  KolabWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardSlox()
{
#ifdef WITH_SLOX
  SloxWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardExchange()
{
#ifdef WITH_NEWEXCHANGE
  ExchangeWizard wizard;
  wizard.exec();
#endif
}

#include "overviewpage.moc"
