/***************************************************************************
 *
 * tdenetman-connection_setting_gsm_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// tdenm headers
#include "tdenetman-connection_setting_gsm_widget.h"

#include "connection_setting_gsm.h"

using namespace ConnectionSettings;

GSMWidgetImpl::GSMWidgetImpl(TDENetworkConnection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	_gsmsetting = dynamic_cast<TDEModemConnection*>(conn);

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingGsmWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
GSMWidgetImpl::Init()
{
	if (_gsmsetting->gsmConfig.valid) {
		_mainWid->mUsername->setText( _gsmsetting->gsmConfig.username );
		_mainWid->mNumber->setText( _gsmsetting->gsmConfig.providerDataNumber );
		_mainWid->mApn->setText( _gsmsetting->gsmConfig.accessPointName );
		_mainWid->mNetworkId->setText( _gsmsetting->gsmConfig.networkID );
		setNetworkType( _gsmsetting->gsmConfig.networkType );
		_mainWid->mBand->setValue( _gsmsetting->gsmConfig.allowedFrequencyBands );
		if (_gsmsetting->gsmConfig.secretsValid) {
			_mainWid->mPassword->setText( _gsmsetting->gsmConfig.password );
			_mainWid->mPin->setText( _gsmsetting->gsmConfig.pin );
		}
	}
		
	connect( _mainWid->mUsername, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mPassword, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mPin, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mNumber, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mApn, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mNetworkId, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(dirty()));
	connect( _mainWid->mNetworkType, TQ_SIGNAL(activated(int)), TQ_SLOT(dirty()));
	connect( _mainWid->mBand, TQ_SIGNAL(valueChanged(int)), TQ_SLOT(dirty()));
}

void
GSMWidgetImpl::Deactivate()
{
}

void
GSMWidgetImpl::Activate()
{

}

void
GSMWidgetImpl::dirty()
{
	_gsmsetting->gsmConfig.username = _mainWid->mUsername->text();
	_gsmsetting->gsmConfig.password = _mainWid->mPassword->text();
	_gsmsetting->gsmConfig.pin = _mainWid->mPin->text();
	_gsmsetting->gsmConfig.providerDataNumber = _mainWid->mNumber->text();
	_gsmsetting->gsmConfig.accessPointName = _mainWid->mApn->text();
	_gsmsetting->gsmConfig.networkID = _mainWid->mNetworkId->text();
	_gsmsetting->gsmConfig.networkType = getNetworkType();
	_gsmsetting->gsmConfig.allowedFrequencyBands = _mainWid->mBand->value();

	_gsmsetting->gsmConfig.valid = true;
	_gsmsetting->gsmConfig.secretsValid = true;

	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}

void
GSMWidgetImpl::setNetworkType(TDEGSMNetworkType::TDEGSMNetworkType type)
{
	if (type == TDEGSMNetworkType::Any) {
		_mainWid->mBand->setValue(0);
	}
	else if (type == TDEGSMNetworkType::Only3G) {
		_mainWid->mBand->setValue(1);
	}
	else if (type == TDEGSMNetworkType::GPRSEdge) {
		_mainWid->mBand->setValue(2);
	}
	else if (type == TDEGSMNetworkType::Prefer3G) {
		_mainWid->mBand->setValue(3);
	}
	else if (type == TDEGSMNetworkType::Prefer2G) {
		_mainWid->mBand->setValue(4);
	}
	else {
		_mainWid->mBand->setValue(0);
	}
}

TDEGSMNetworkType::TDEGSMNetworkType
GSMWidgetImpl::getNetworkType()
{
	int itemNo = _mainWid->mNetworkType->currentItem();
	if (itemNo == 0) {
		return TDEGSMNetworkType::Any;
	}
	else if (itemNo == 1) {
		return TDEGSMNetworkType::Only3G;
	}
	else if (itemNo == 2) {
		return TDEGSMNetworkType::GPRSEdge;
	}
	else if (itemNo == 3) {
		return TDEGSMNetworkType::Prefer3G;
	}
	else if (itemNo == 4) {
		return TDEGSMNetworkType::Prefer2G;
	}
	else {
		return TDEGSMNetworkType::Any;
	}
}

#include "tdenetman-connection_setting_gsm_widget.moc"
