/* This file is part of ksirc
   Copyright (c) 2003 Andrew Stanley-Jones <asj@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

// $Id$

#include <tqstring.h>
#include <tqcolor.h>
#include <tqregexp.h>
#include <kdebug.h>

#include "nickColourMaker.h"
#include "ksopts.h"

nickColourMaker *nickColourMaker::s_ncm = 0;

nickColourMaker::nickColourMaker()
{
    s_ncm = this;
}

int nickColourMaker::findIdx(TQString nick) const
{
    unsigned int value = 0;
    uint i;
    ushort c;

    if(ksopts->nickColourization == false)
        return -1;

    for(i = 0; i < nick.length(); i++){
        c = nick[i].unicode();
	switch(c){
	case '|':
	case '-':
	case '_':
            if(i != 0)
		i = nick.length();
	    else
                value += c;
	    break;
	default:
            value += c;
	}
    }
    value %= ksopts->numColors;
    uint start = value;
    while(ksopts->nickHighlight[value] == false){
	value = (value + 1) % ksopts->numColors;
	if(start == value)
            return -1;

    }


    return value;

}

TQColor nickColourMaker::findFg(TQString nick) const
{

    int value = findIdx(nick);

    if(value >= 0)
	return ksopts->ircColors[value];
    else if(ksopts->nickForeground.isValid())
        return ksopts->nickForeground;
    else
	return ksopts->textColor;
}

