
#ifndef KMESSAGERECEIVER_H
#define KMESSAGERECEIVER_H

#include <tqstring.h>
#include <tqptrlist.h>

class KSircProcess;
class TQTextCodec;

struct filterRule {
    const char *desc;
    const char *search;
    const char *from;
    const char *to;
};

typedef TQPtrList<filterRule> filterRuleList;

class KSircMessageReceiver
{
public:
  KSircMessageReceiver(KSircProcess *_proc);
  virtual ~KSircMessageReceiver();

    virtual void sirc_receive(TQCString str, bool broadcast = false) = 0;

    virtual void control_message(int, TQString) = 0;

  bool getBroadcast();
  void setBroadcast(bool bd);

  virtual filterRuleList *defaultRules();

  KSircProcess *ksircProcess() const { return proc; }

private:
  KSircProcess *proc;
  bool broadcast;

};

class UnicodeMessageReceiver : public KSircMessageReceiver
{
public:
    UnicodeMessageReceiver( KSircProcess *process );

    virtual void sirc_receive(TQCString str, bool broadcast = false);
    virtual void sirc_receive(TQString str, bool broadcast = false) = 0;

protected:
    void setEncoding( const TQString &encoding );
    TQString encoding() const;

    TQTextCodec *encoder() const;

private:
    TQString m_encoding;
    TQTextCodec *m_encoder;
};

#endif
