/*
  KPF - Public fileserver for KDE

  Copyright 2001 Rik Hemsley (rikkus) <rik@kde.org>

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to
  deal in the Software without restriction, including without limitation the
  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
  sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ErrorMessageConfigDialog.h"
#include "ErrorMessageConfigDialog.moc"

#include <tqlabel.h>
#include <tqframe.h>
#include <tqlayout.h>

#include <kurlrequester.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kdialog.h>

#include "Defines.h"
#include "Defaults.h"
#include "Utils.h"

namespace KPF
{
  ErrorMessageConfigDialog::ErrorMessageConfigDialog
  (
   WebServer  * webServer,
   TQWidget    * parent
  )
    : KDialogBase
    (
     parent,
     "ErrorMessageConfigDialog",
     false,
     i18n("Configure error messages"),
     KDialogBase::Ok | KDialogBase::Cancel,
     KDialogBase::Cancel,
     true // Use a separator.
    ),
    server_(webServer)
  {
    TQValueList<uint> codeList;

    codeList << 400 << 403 << 404 << 412 << 416 << 500 << 501;

    TQFrame * w = makeMainWidget();

    TQVBoxLayout * layout =
      new TQVBoxLayout(w, KDialog::marginHint(), KDialog::spacingHint());

    TQLabel * info =
      new TQLabel
      (
       i18n
       (
        "<p>Here you may select files to use instead of the default error"
        " messages passed to a client.</p>"
        "<p>The files may contain anything you wish, but by convention"
        " you should report the error code and the English version of"
        " the error message (e.g. \"Bad request\"). Your file should"
        " also be valid HTML.</p>"
        "<p>The strings ERROR_MESSAGE, ERROR_CODE and RESOURCE, if"
        " they exist in the file, will be replaced with the English"
        " error message, the numeric error code and the path of the"
        " requested resource, respectively.</p>"
       ),
       w
      );

    layout->addWidget(info);

    TQGridLayout * grid = new TQGridLayout(layout, codeList.count(), 2);

    TQString pattern(i18n("%1 %2"));

    TDEConfig config(Config::name());

    config.setGroup("ErrorMessageOverrideFiles");

    TQValueList<uint>::ConstIterator it;

    for (it = codeList.begin(); it != codeList.end(); ++it)
    {
      TQString originalPath =
        config.readPathEntry(TQString::number(*it));

      TQString responseName(translatedResponseName(*it));

      KURLRequester * requester = new KURLRequester(originalPath, w);

      itemList_.append(new Item(*it, requester, responseName, originalPath));

      TQLabel * l = new TQLabel(pattern.arg(*it).arg(responseName), w);

      l->setBuddy(requester);

      grid->addWidget(l,          *it, 0);
      grid->addWidget(requester,  *it, 1);
    }
  }

  ErrorMessageConfigDialog::~ErrorMessageConfigDialog()
  {
    itemList_.setAutoDelete(true);
    itemList_.clear();
  }

    void
  ErrorMessageConfigDialog::slotURLRequesterTextChanged(const TQString &)
  {
  }

    void
  ErrorMessageConfigDialog::accept()
  {
    TDEConfig config(Config::name());

    config.setGroup("ErrorMessageOverrideFiles");

    TQPtrListIterator<Item> it(itemList_);

    for (; it.current(); ++it)
    {
      config.writePathEntry
        (
         TQString::number(it.current()->code),
         it.current()->urlRequester->url()
        );
    }

    config.sync();

    KDialogBase::accept();
  }
}
