/*
  KPF - Public fileserver for KDE

  Copyright 2001 Rik Hemsley (rikkus) <rik@kde.org>

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to
  deal in the Software without restriction, including without limitation the
  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
  sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef KPF_CONFIG_DIALOG_PAGE_H
#define KPF_CONFIG_DIALOG_PAGE_H

#include <tqptrlist.h>
#include <tqwidget.h>

class TQLabel;
class TQSpinBox;
class TQCheckBox;
class TQPushButton;
class TQLineEdit;

namespace KPF
{
  class WebServer;
  class ErrorMessageConfigDialog;

  /**
   * Allows user configuration of a WebServer object.
   */
  class ConfigDialogPage : public TQWidget
  {
    TQ_OBJECT
  

    public:

      ConfigDialogPage(WebServer *, TQWidget * parent);

      virtual ~ConfigDialogPage();

      /**
       * Read settings from associated WebServer object and update controls.
       */
      void load();

      /**
       * Set attributes of associated WebServer object from controls.
       */
      void save();

      void checkOk();

    protected slots:

      void slotConfigureErrorMessages();
      void slotCustomErrorMessagesToggled(bool);
      void slotListenPortChanged(int);
      void slotBandwidthLimitChanged(int);
      void slotFollowSymlinksToggled(bool);

    protected:

      void checkOkAndEmit();

    signals:

      void ok(bool);

    private:

      WebServer * server_;

      TQLabel    * l_listenPort_;
      TQLabel    * l_bandwidthLimit_;
      TQLabel    * l_connectionLimit_;
      TQLabel	* l_serverName_;

      TQSpinBox  * sb_listenPort_;
      TQSpinBox  * sb_bandwidthLimit_;
      TQSpinBox  * sb_connectionLimit_;

      TQCheckBox * cb_followSymlinks_;
      
      TQLineEdit * le_serverName_;

      TQCheckBox     * cb_customErrorMessages_;
      TQPushButton   * pb_errorMessages_;

      ErrorMessageConfigDialog * errorMessageConfigDialog_;
  };
}

#endif
