/***************************************************************************
                          wppreferences.cpp  -  description
                             -------------------
    begin                : Fri Apr 26 2002
    copyright            : (C) 2002 by Gav Wood
    email                : gav@kde.org

    Based on code from   : (C) 2002 by Duncan Mac-Vicar Prett
    email                : duncan@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// QT Includes
#include <tqlayout.h>

// KDE Includes
#include <kcombobox.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <tdemessagebox.h>
#include <tdelocale.h>

// Kopete Includes
#include <addcontactpage.h>

// Local Includes
#include "wpaddcontactbase.h"
#include "wpaccount.h"
#include "wpaddcontact.h"

WPAddContact::WPAddContact(TQWidget *parent, WPAccount *newAccount, const char *name) : AddContactPage(parent, name)
{
//	kdDebug(14170) << "WPAddContact::WPAddContact(<owner>, " << newAccount << ", <parent>, " << name << ")" << endl;

	(new TQVBoxLayout(this))->setAutoAdd(true);
	theDialog = new WPAddContactBase(this);
	connect(theDialog->mHostGroup, TQ_SIGNAL(activated(const TQString &)), this, TQ_SLOT(slotSelected(const TQString &)));
	connect(theDialog->mRefresh, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotUpdateGroups()));
	theDialog->show();

	theAccount = newAccount;

	slotUpdateGroups();
	slotSelected(theDialog->mHostGroup->currentText());
}

WPAddContact::~WPAddContact()
{
}

void WPAddContact::slotUpdateGroups()
{
	kdDebug(14170) << "WPAddContact::slotUpdateGroups()" << endl;

	theDialog->mHostGroup->clear();
	TQStringList Groups = theAccount->getGroups();
	TQStringList::ConstIterator end = Groups.end();
	for (TQStringList::ConstIterator i = Groups.begin(); i != end; i++)
		theDialog->mHostGroup->insertItem(SmallIcon("network"), *i);
	slotSelected(theDialog->mHostGroup->currentText());
}

void WPAddContact::slotSelected(const TQString &Group)
{
	kdDebug(14170) << "WPAddContact::slotSelected(" << Group << ")" << endl;

	theDialog->mHostName->clear();
	TQStringList Hosts = theAccount->getHosts(Group);
	TQString ownHost = theAccount->myself()->contactId();
	TQStringList::ConstIterator end = Hosts.end();
	for (TQStringList::ConstIterator i = Hosts.begin(); i != end; i++)
		if (*i != ownHost) theDialog->mHostName->insertItem(SmallIcon("preferences-desktop-personal"), *i);
}

bool WPAddContact::validateData()
{
	kdDebug(14170) << "WPAddContact::validateData()" << endl;

	TQString tmpHostName = theDialog->mHostName->currentText();

	if (tmpHostName.isEmpty()) {
		KMessageBox::sorry(this, i18n("<qt>You must enter a valid hostname.</qt>"), i18n("WinPopup"));
		return false;
	}

	// If our own host is not allowed as contact localhost should be forbidden as well,
	// additionally somehow localhost as contact crashes when receiving a message from it?? GF
	if (tmpHostName.upper() == TQString::fromLatin1("LOCALHOST")) {
		KMessageBox::sorry(this, i18n("<qt>LOCALHOST is not allowed as contact.</qt>"), i18n("WinPopup"));
		return false;
	}

	return true;
}

bool WPAddContact::apply(Kopete::Account *theAccount, Kopete::MetaContact *theMetaContact)
{
	kdDebug(14170) << "WPAddContact::apply(" << theAccount << ", " << theMetaContact << ")" << endl;

	// TODO: make the nickname an option
	return theAccount->addContact(theDialog->mHostName->currentText(), theMetaContact, Kopete::Account::ChangeKABC );
}

#include "wpaddcontact.moc"
