/*
 * xmpp_vcard.h - classes for handling vCards
 * Copyright (C) 2003  Michail Pishchagin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef JABBER_VCARD_H
#define JABBER_VCARD_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqcstring.h>

#include <tqvaluelist.h>
#include <tqdom.h>

class TQDate;

namespace XMPP
{
	class VCard
	{
	public:
		VCard();
		VCard(const VCard &);
		VCard & operator=(const VCard &);
		~VCard();

		TQDomElement toXml(TQDomDocument *) const;
		bool fromXml(const TQDomElement &);
		bool isEmpty() const;

		const TQString &version() const;
		void setVersion(const TQString &);

		const TQString &fullName() const;
		void setFullName(const TQString &);


		const TQString &familyName() const;
		void setFamilyName(const TQString &);

		const TQString &givenName() const;
		void setGivenName(const TQString &);

		const TQString &middleName() const;
		void setMiddleName(const TQString &);

		const TQString &prefixName() const;
		void setPrefixName(const TQString &);

		const TQString &suffixName() const;
		void setSuffixName(const TQString &);


		const TQString &nickName() const;
		void setNickName(const TQString &);


		const TQByteArray &photo() const;
		void setPhoto(const TQByteArray &);

		const TQString &photoURI() const;
		void setPhotoURI(const TQString &);


		const TQDate bday() const;
		void setBday(const TQDate &);

		const TQString &bdayStr() const;
		void setBdayStr(const TQString &);


		class Address {
		public:
			Address();

			bool home;
			bool work;
			bool postal;
			bool parcel;

			bool dom;
			bool intl;

			bool pref;

			TQString pobox;
			TQString extaddr;
			TQString street;
			TQString locality;
			TQString region;
			TQString pcode;
			TQString country;
		};
		typedef TQValueList<Address> AddressList;
		const AddressList &addressList() const;
		void setAddressList(const AddressList &);

		class Label {
		public:
			Label();

			bool home;
			bool work;
			bool postal;
			bool parcel;

			bool dom;
			bool intl;

			bool pref;

			TQStringList lines;
		};
		typedef TQValueList<Label> LabelList;
		const LabelList &labelList() const;
		void setLabelList(const LabelList &);


		class Phone {
		public:
			Phone();

			bool home;
			bool work;
			bool voice;
			bool fax;
			bool pager;
			bool msg;
			bool cell;
			bool video;
			bool bbs;
			bool modem;
			bool isdn;
			bool pcs;
			bool pref;

			TQString number;
		};
		typedef TQValueList<Phone> PhoneList;
		const PhoneList &phoneList() const;
		void setPhoneList(const PhoneList &);


		class Email {
		public:
			Email();

			bool home;
			bool work;
			bool internet;
			bool x400;

			TQString userid;
		};
		typedef TQValueList<Email> EmailList;
		const EmailList &emailList() const;
		void setEmailList(const EmailList &);


		const TQString &jid() const;
		void setJid(const TQString &);

		const TQString &mailer() const;
		void setMailer(const TQString &);

		const TQString &timezone() const;
		void setTimezone(const TQString &);


		class Geo {
		public:
			Geo();

			TQString lat;
			TQString lon;
		};
		const Geo &geo() const;
		void setGeo(const Geo &);


		const TQString &title() const;
		void setTitle(const TQString &);

		const TQString &role() const;
		void setRole(const TQString &);


		const TQByteArray &logo() const;
		void setLogo(const TQByteArray &);

		const TQString &logoURI() const;
		void setLogoURI(const TQString &);


		const VCard *agent() const;
		void setAgent(const VCard &);

		const TQString agentURI() const;
		void setAgentURI(const TQString &);


		class Org {
		public:
			Org();

			TQString name;
			TQStringList unit;
		};
		const Org &org() const;
		void setOrg(const Org &);


		const TQStringList &categories() const;
		void setCategories(const TQStringList &);

		const TQString &note() const;
		void setNote(const TQString &);

		const TQString &prodId() const; // it must equal to "Psi" ;-)
		void setProdId(const TQString &);

		const TQString &rev() const;
		void setRev(const TQString &);

		const TQString &sortString() const;
		void setSortString(const TQString &);


		const TQByteArray &sound() const;
		void setSound(const TQByteArray &);

		const TQString &soundURI() const;
		void setSoundURI(const TQString &);

		const TQString &soundPhonetic() const;
		void setSoundPhonetic(const TQString &);


		const TQString &uid() const;
		void setUid(const TQString &);

		const TQString &url() const;
		void setUrl(const TQString &);

		const TQString &desc() const;
		void setDesc(const TQString &);


		enum PrivacyClass {
			pcNone = 0,
			pcPublic = 1,
			pcPrivate,
			pcConfidential
		};
		const PrivacyClass &privacyClass() const;
		void setPrivacyClass(const PrivacyClass &);


		const TQByteArray &key() const;
		void setKey(const TQByteArray &);

	private:
		class Private;
		Private *d;
	};
}

#endif
