/*
    kcodecaction.cpp

    Copyright (c) 2005      by Tommi Rantala  <tommi.rantala@cs.helsinki.fi>
    Copyright (c) 2003      by Jason Keirstead        <jason@keirstead.org>
    Kopete    (c) 2003-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include <tqstringlist.h>
#include <tqtextcodec.h>
#include <kcharsets.h>

#include "kcodecaction.h"

KCodecAction::KCodecAction( const TQString &text, const TDEShortcut &cut,
		TQObject *parent, const char *name ) : TDESelectAction( text, "", cut, parent, name )
{
	TQObject::connect( this, TQ_SIGNAL( activated( const TQString & ) ),
			this, TQ_SLOT( slotActivated( const TQString & ) ) );

	setItems( KCodecAction::supportedEncodings() );
}

void KCodecAction::slotActivated( const TQString & text )
{
	/* text is something like "Western European ( iso-8859-1 )", but we must give
	 * codecForName() only the "iso-8859-1" part.
	 */
	TQString encoding = TDEGlobal::charsets()->encodingForName(text);

	emit activated( TDEGlobal::charsets()->codecForName(encoding) );
}

void KCodecAction::setCodec( const TQTextCodec *codec )
{
	TQStringList items = this->items();
	int i = 0;
	for (TQStringList::ConstIterator it = items.begin(), end = items.end(); it != end; ++it, ++i) {
		TQString encoding = TDEGlobal::charsets()->encodingForName(*it);

		if (TDEGlobal::charsets()->codecForName(encoding)->mibEnum() == codec->mibEnum()) {
			setCurrentItem(i);
			break;
		}
	}
}

/* Create a list of supported encodings, and keep only one of each encoding
 * mime name.
 *
 * This piece of code from tdepim/kmail/kmmsgbase.cpp
 */

TQStringList KCodecAction::supportedEncodings(bool usAscii)
{
	TQStringList encodingNames = TDEGlobal::charsets()->availableEncodingNames();
	TQStringList encodings;
	TQMap<TQString, bool> mimeNames;

	for (TQStringList::ConstIterator it = encodingNames.begin();
			it != encodingNames.end(); ++it)
	{
		TQTextCodec *codec = TDEGlobal::charsets()->codecForName(*it);
		TQString mimeName = (codec) ? TQString(codec->mimeName()).lower() : (*it);
		if (mimeNames.find(mimeName) == mimeNames.end())
		{
			encodings.append(TDEGlobal::charsets()->languageForEncoding(*it)
					+ " ( " + mimeName + " )");
			mimeNames.insert(mimeName, true);
		}
	}

	encodings.sort();
	if (usAscii) encodings.prepend(TDEGlobal::charsets()
			->languageForEncoding("us-ascii") + " ( us-ascii )");
	return encodings;
}

#include "kcodecaction.moc"
