/*
    historypreferences.cpp

    Copyright (c) 2003 by Olivier Goffart             <ogoffart @ kde.org>
              (c) 2003 by Stefan Gehn                 <metz AT gehn.net>
    Kopete    (c) 2003-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "historypreferences.h"
#include "historyconfig.h"
#include "historyprefsui.h"

#include <kgenericfactory.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <kcolorbutton.h>
#include <knuminput.h>
#include <tqcheckbox.h>

typedef KGenericFactory<HistoryPreferences> HistoryConfigFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_history, HistoryConfigFactory( "kcm_kopete_history" ) )

HistoryPreferences::HistoryPreferences(TQWidget *parent, const char*/*name*/, const TQStringList &args)
	: TDECModule(HistoryConfigFactory::instance(), parent, args)
{
	kdDebug(14310) << k_funcinfo << "called." << endl;
	(new TQVBoxLayout(this))->setAutoAdd(true);
	p = new HistoryPrefsUI(this);

	connect(p->chkShowPrevious, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotShowPreviousChanged(bool)));
	connect(p->Number_Auto_chatwindow, TQ_SIGNAL(valueChanged(int)),
		this, TQ_SLOT(slotModified()));
	connect(p->Number_ChatWindow, TQ_SIGNAL(valueChanged(int)),
		this, TQ_SLOT(slotModified()));
	connect(p->History_color, TQ_SIGNAL(changed(const TQColor&)),
		this, TQ_SLOT(slotModified()));
	load();
}

HistoryPreferences::~HistoryPreferences()
{
	kdDebug(14310) << k_funcinfo << "called." << endl;
}

void HistoryPreferences::load()
{
	kdDebug(14310) << k_funcinfo << "called." << endl;
	HistoryConfig::self()->readConfig();
	p->chkShowPrevious->setChecked(HistoryConfig::auto_chatwindow());
	slotShowPreviousChanged(p->chkShowPrevious->isChecked());
	p->Number_Auto_chatwindow->setValue(HistoryConfig::number_Auto_chatwindow());
	p->Number_ChatWindow->setValue(HistoryConfig::number_ChatWindow());
	p->History_color->setColor(HistoryConfig::history_color());
	//p-> HistoryConfig::browserStyle();
	emit TDECModule::changed(false);
}

void HistoryPreferences::save()
{
	kdDebug(14310) << k_funcinfo << "called." << endl;
	HistoryConfig::setAuto_chatwindow(p->chkShowPrevious->isChecked());
	HistoryConfig::setNumber_Auto_chatwindow(p->Number_Auto_chatwindow->value());
	HistoryConfig::setNumber_ChatWindow(p->Number_ChatWindow->value());
	HistoryConfig::setHistory_color(p->History_color->color());
	HistoryConfig::self()->writeConfig();
	emit TDECModule::changed(false);
}

void HistoryPreferences::slotModified()
{
	emit TDECModule::changed(true);
}

void HistoryPreferences::slotShowPreviousChanged(bool on)
{
	emit TDECModule::changed(true);
}

#include "historypreferences.moc"
