/*
 * newsiconmgr.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef NEWSICONMGR_H
#define NEWSICONMGR_H

#include <tqobject.h>
#include <tqpixmap.h>

#include <dcopobject.h>
#include <tdeio/job.h>
#include <kurl.h>

class DCOPClient;

struct KIODownload;
typedef TQMap<TDEIO::Job *, KIODownload> KIODownloadMap;

class NewsIconMgr : public TQObject, public DCOPObject
{
	TQ_OBJECT
//	
	K_DCOP

	public:
		static NewsIconMgr *self();
	
		void getIcon(const KURL &);
		bool isStdIcon(const TQPixmap &) const;
	
	k_dcop:
		void slotGotIcon(bool, TQString, TQString);
	
	signals:
		void gotIcon(const KURL &, const TQPixmap &);
	
	protected:
		NewsIconMgr(TQObject * = 0L, const char * = 0L);
		~NewsIconMgr();
		
	private slots:
		void slotData(TDEIO::Job *, const TQByteArray &);
		void slotResult(TDEIO::Job *);

	private:
		TQString favicon(const KURL &) const;

		TQPixmap        m_stdIcon;
		KIODownloadMap m_tdeioDownload;

		static NewsIconMgr *m_instance;
};

#endif // NEWSICONMGR_H
