/*
 * configWidget - the config dialog page for KSCD settings
 *
 * $Id:
 *
 * Copyright (c) 2002 Aaron J. Seigo <aseigo@kde.org>
 * Copyright (c) 2004 Alexander Kern <alex.kern@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include <kdebug.h>
#include <klineedit.h>
#include <dcopref.h>
#include <kurlrequester.h>
#include <tqcheckbox.h>
#include <kcombobox.h>
#include <tqlayout.h>

#include <config.h>
extern "C" {
    // We don't have libWorkMan installed already, so get everything
    // from within our own directory
#include "libwm/include/wm_config.h"
}


#include "configWidget.h"
#include "kscd.h"
#include "prefs.h"

class SpecialComboBox : public KComboBox
{
public:
  SpecialComboBox(TQWidget* parent, const char* name)
   : KComboBox(parent, name)
   {}

  // TQComboBox::setCurrentText replaces the current text if
  // the list doesn't contain text, while
  // KComboBox::setCurrentItem doesn't
  void setCurrentText(const TQString& text)
  {
    setCurrentItem(text);
  }
} ;

/*
 *  Constructs a configWidget which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
configWidget::configWidget(KSCD* player, TQWidget* parent, const char* name)
    : configWidgetUI(parent, name),
      mPlayer(player)
{
    if (!name)
    {
        setName("configWidget");
    }

    kcfg_cdDevice->comboBox()->setEditable(true);
    kcfg_cdDevice->comboBox()->insertItem(DEFAULT_CD_DEVICE);
    getMediaDevices();

    (new TQVBoxLayout(audioSystemFrame))->setAutoAdd(true);
    kcfg_AudioSystem = new SpecialComboBox(audioSystemFrame, "kcfg_AudioSystem");
    textLabel4->setBuddy(kcfg_AudioSystem);
    
#if defined(BUILD_CDDA)
    kcfg_DigitalPlayback_toggled(Prefs::digitalPlayback());
    
    // fill ComboBox audioBackend
    kcfg_AudioSystem->insertStringList(mPlayer->audioSystems());
#else
    kcfg_DigitalPlayback_toggled(false);
    
    kcfg_DigitalPlayback->setChecked(false);
    kcfg_DigitalPlayback->hide();
#endif
    kcfg_SelectEncoding_toggled(Prefs::selectEncoding());
}

configWidget::~configWidget()
{
}

void configWidget::kcfg_DigitalPlayback_toggled(bool toggle)
{
    kcfg_AudioSystem->setEnabled(toggle);
    textLabel4->setEnabled(toggle);
    kcfg_AudioDevice->setEnabled(toggle);
    textLabel5->setEnabled(toggle);
}

void configWidget::getMediaDevices()
{
    DCOPRef ref("kded","mediamanager");
    DCOPReply rep = ref.call("fullList()");
    if (!rep.isValid()) {
        return;
    }
    TQStringList list = rep;
    TQStringList::const_iterator it = list.begin();
    TQStringList::const_iterator itEnd = list.end();
    // it would be much better if libmediacommon was in tdelibs
    // see tdebase/tdeioslave/media/libmediacommon/medium.h
    while (it != itEnd) {
	TQString url;
	for ( int i = 0; i<12 && it != itEnd; i++, ++it ) {
		if (i == 2) { // NAME
			url = "media:/"+(*it);
			kdDebug() << "checking " << url << endl;
		}
		if (i == 11) { // MIME_TYPE
			kdDebug() << "Mime: " << *it << endl;
			if ((*it)=="media/audiocd") {
				kcfg_cdDevice->comboBox()->insertItem(url);
			}
		}
	}
        while (it !=itEnd && (*it)!="---") ++it;  // go to end of current device's properties
        ++it;
    }
}
 

void configWidget::kcfg_SelectEncoding_toggled(bool toggle)
{
    kcfg_SelectedEncoding->setEnabled(toggle);
}

#include "configWidget.moc"
