// Author: Denis Kozadaev - (c) 2025


#ifndef	__GAME_BOARD_H__
#define	__GAME_BOARD_H__

#include <stdlib.h>

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqtimer.h>

typedef	TQValueList<int>	ValidMoves;

class GameBoard:public TQWidget
{
	TQ_OBJECT
public:

	GameBoard(TQWidget *parent = nullptr, const char *name = nullptr);
	~GameBoard();

	void	newGame(int);
	void	setTips(bool);
	void	setKnight(bool);
	void	setRandomCell(bool);

private:
	int		config;
	int		map_size, curr;
	int		*map;
	int		kpos;	/* knight position (in the map) */
	TQPixmap	*xpm;
	TQPixmap	*kxpm;
	TQImage		*knight;
	ValidMoves	vmove;
	TQColor		paperColor;

	void	initMap(int);
	void	redrawMap();
	void	adjustDelta(int, int, int&, int&, int&, int&);
	void	predictMoves();
	void	ifAppend(ValidMoves&, int, int);
	void	fromLinear(int, int&, int&);
	void	generateCell();

	int	toMap(int, int);
	int	mayMove(int);
	int	toLinear(int, int);

protected:
	void	resizeEvent(TQResizeEvent *);
	void	mousePressEvent(TQMouseEvent *);
	void	paintEvent(TQPaintEvent *);
};

#endif	/* __GAME_BOARD_H__ */
