/***************************************************************************
    begin                : Tue May  2 15:47:11 CEST 2000
    copyright            : (C) 2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include "lskat.h"

static TDECmdLineOptions options[] =
{
  { "d", 0, 0},
  { "debug <level>", I18N_NOOP("Enter debug level"), 0 },
  TDECmdLineLastOption
};

int global_debug;

int main(int argc, char *argv[])
{

  global_debug=0;
  TDEAboutData aboutData( "lskat", I18N_NOOP("Lieutenant Skat"),
                        "1.0",
                        I18N_NOOP("Card Game"),
                        TDEAboutData::License_GPL,
                        "(c) 2000, Martin Heni");
  aboutData.addAuthor("Martin Heni",0, "martin@heni-online.de");
  aboutData.addCredit("Laura", I18N_NOOP("Beta testing"), 0);
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  /* command line handling */
  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if (args->isSet("debug"))
  {
    TQString s = args->getOption("debug");
    global_debug = s.toInt();
    tqDebug("Debug level set to %d\n", global_debug);
  }
  args->clear();

  TDEApplication app;

  if (app.isRestored())
  {
    RESTORE(LSkatApp);
  }
  else
  {
    LSkatApp *lskat = new LSkatApp();
    lskat->show();
  }

  return app.exec();
}
