/***************************************************************************
                          KEMessage.h  -  description
                             -------------------
    begin                : Tue May 2 2000
    copyright            : (C) 2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _KEMESSAGE_H_
#define _KEMESSAGE_H_

#include <string.h>
#include <tqstring.h>
#include <tqstrlist.h>
#include <tqdict.h>
#include "KMessageEntry.h"

#define KEMESSAGE_HEAD TQString(TQCString("BEGIN_V1000"))
#define KEMESSAGE_TAIL TQString(TQCString("END_V1000"))
#define KEMESSAGE_CR   TQString(TQCString("\n"))
#define KEMESSAGE_SEP  TQString(TQCString(":::"))

class KEMessage
{
  private:
  TQStrList keys;
  TQDict<KMessageEntry> dict;

  protected:
  void AddEntry(TQString key,KMessageEntry *entry);
  public:
  TQStrList *QueryKeys();
  uint QueryNumberOfKeys();
  void AddDataType(TQString key,int size,const char *data,KGM_TYPE type);
  void AddData(TQString key,short data);
  void AddData(TQString key,long data);
  void AddData(TQString key,float data);
  void AddData(TQString key,const char *data,int size=-1);
  bool GetData(TQString key,short &s);
  bool GetData(TQString key,long &l);
  bool GetData(TQString key,float &f);
  bool GetData(TQString key,char * &c,int &size);
  bool HasKey(TQString key);
  void Remove(TQString key);
  KGM_TYPE QueryType(TQString key);
  TQString ToString();
  TQString EntryToString(char *key,KMessageEntry *entry);
  TQString StringToEntry(TQString str,KMessageEntry *entry);
  bool AddString(TQString s);
  bool AddStringMsg(TQString str);
  void RemoveAll();
  ~KEMessage();
  KEMessage();
  KEMessage(KEMessage &msg);
  KEMessage &operator=(KEMessage &msg);
};

#endif
