/*
 *   ksame 0.4 - simple Game
 *   Copyright (C) 1997,1998  Marcus Kreutzberger
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
#include <stdio.h>

#include <tqwidget.h>

#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>

#include "version.h"
#include "KSameWidget.h"
#include <tdeaboutdata.h>
#include <tdeglobal.h>

static const char description[] = I18N_NOOP("Same Game - a little game about balls and how to get rid of them");
static const char copyright[] = "(c) 1997-1998 Marcus Kreutzberger";

int main( int argc, char **argv ) {
	TDEAboutData aboutData("ksame", I18N_NOOP("SameGame"), KSAME_VERSION,
                         description, TDEAboutData::License_GPL, copyright);
    aboutData.addAuthor("Marcus Kreutzberger", 0, "kreutzbe@informatik.mu-luebeck.de");
    TDECmdLineArgs::init(argc, argv, &aboutData);

    TDEApplication::setColorSpec(TQApplication::ManyColor+TQApplication::CustomColor);
    TDEApplication a;
    TDEGlobal::locale()->insertCatalogue("libtdegames");

    KSameWidget *w = new KSameWidget;
    if (tdeApp->isRestored()) {
        if (KSameWidget::canBeRestored(1))
            w->restore(1);
    } else
        w->show();
    a.setMainWidget(w);

    return a.exec();
}
