/***************************************************************************

                     properties for a language

    -----------------------------------------------------------------------

    begin                : Thu Mar 11 20:50:53 MET 1999

    copyright            : (C) 1999-2001 Ewald Arnold
                           (C) 2001 The KDE-EDU team

    email                : kvoctrain@ewald-arnold.de

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#ifndef langset_h
#define langset_h

#include <vector>
using namespace std;

#include <tqstring.h>
#include <tdemacros.h>


class TDE_EXPORT LangSet
{
 public:

   LangSet () {}

   void addSet (TQString shortId, TQString longId, TQString PixMapFile,
		const TQString& shortId2 = TQString(),
		const TQString& keyboardLayout = TQString());

/*    void addSet (TQString shortId, TQString shortId2, TQString longId, */
/* 		TQString PixMapFile,  */
/* 		const TQString& keyboardLayout = TQString()); */

   void appendSet(const LangSet &set);

   unsigned int size () const { return langs.size(); }
   void erase (int idx);
   void clear ();

   TQString shortId (int index) const;
   TQString shortId2 (int index) const;
   TQString longId (int index) const;
   TQString PixMapFile (int index) const;
   TQString keyboardLayout (int index) const;

   int indexShortId (TQString shortId) const;
   int indexLongId (TQString longId) const;
   int indexPixMapFile (TQString PixMapFile) const;
   // doesn't make sense for keyboard layouts since there is no 1-to-1 relation to languages

   void setShortId (const TQString & shortId, int index);
   void setShortId2 (const TQString & shortId2, int index);
   void setLongId (const TQString & longId, int index);
   void setPixMapFile (const TQString & PixMapFile, int index);
   void setKeyboardLayout(const TQString & layout, int index);

   TQString findShortId (const TQString & longId)  const;
   TQString findLongId  (const TQString & shortId) const;

 private:

   struct LangDef {
     TQString shortId,
             shortId2,
             longId,
       PixMapFile,
       keyboardLayout;
   };

   vector<LangDef> langs;
};


#endif // langset_h
