/* This file is part of the KDE project
 *
 * Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
 * Copyright (C) 2001 Philippe Fremy <pfremy@chez.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef __xp_notepad_factory_h__
#define __xp_notepad_factory_h__

#include <tdeparts/factory.h>
#include <tqptrlist.h>
#include <kurl.h>
#include "xparthost_kpart.h"

class TDEInstance;
class TDEAboutData;
class TDEHTMLSettings;
class TDEHTMLPart;
class TDEProcess;

class XP_NotepadFactory : public KParts::Factory
{
  TQ_OBJECT
public:
  XP_NotepadFactory( bool clone = false ) {}
  virtual ~XP_NotepadFactory() {}

  virtual KParts::Part *createPartObject( TQWidget *parentWidget, const char *widgetName, TQObject *parent, const char *name, const char *className, const TQStringList &args );

};



class XP_NotepadPart : public XPartHost_KPart
{
    TQ_OBJECT

public:
    XP_NotepadPart(TQWidget *parentWidget, const char *widgetName,
	           TQObject *parent, const char *name);
    virtual ~XP_NotepadPart();

    virtual void createActions( const TQCString &xmlActions );
private:
    TDEProcess *m_partProcess;
};

#endif
