//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQObject;
import org.trinitydesktop.qt.TQPopupMenu;
import org.trinitydesktop.qt.TQPixmap;
import org.trinitydesktop.qt.TQLineEdit;
import org.trinitydesktop.qt.TQEvent;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQWheelEvent;
import org.trinitydesktop.qt.TQComboBox;

/**

 A combined button, line-edit and a popup list widget.
 <li><b>Detail </b></li>
 This widget inherits from TQComboBox and implements the following
 additional functionalities:  a completion object that provides both automatic
 and manual text completion as well as text rotation features, configurable
 key-bindings to activate these features, and a popup-menu item that can be
 used to allow the user to change the text completion mode on the fly.
 To support these new features KComboBox emits a few additional signals
 such as completion( String ) and textRotation( KeyBindgingType ).
 The completion signal can be connected to a slot that will assist the user in
 filling out the remaining text while the rotation signal can be used to traverse
 through all possible matches whenever text completion results in multiple matches.
 Additionally, a returnPressed() and a returnPressed( String )
 signals are emitted when the user presses the Enter/Return key.
 KCombobox by default creates a completion object when you invoke the
 completionObject( boolean ) member function for the first time or
 explicitly use setCompletionObject( TDECompletion, boolean ) to assign your
 own completion object.  Additionally, to make this widget more functional,
 KComboBox will by default handle text rotation and completion events
 internally whenever a completion object is created through either one of the
 methods mentioned above.  If you do not need this functionality, simply use
 TDECompletionBase.setHandleSignals(boolean) or alternatively set the booleanean
 parameter in the <code>setCompletionObject</code> call to false.
 Beware: The completion object can be deleted on you, especially if a call
 such as setEditable(false) is made.  Store the pointer at your own risk,
 and consider using TQGuardedPtr<TDECompletion>.
 The default key-bindings for completion and rotation is determined from the
 global settings in TDEStdAccel. These values, however, can be overridden
 locally by invoking TDECompletionBase.setKeyBinding(). The values can
 easily be reverted back to the default setting, by simply calling
 useGlobalSettings(). An alternate method would be to default individual
 key-bindings by usning setKeyBinding() with the default second argument.
 A non-editable combobox only has one completion mode, <code>CompletionAuto.</code>
 Unlike an editable combobox the CompletionAuto mode, works by matching
 any typed key with the first letter of entries in the combobox. Please note
 that if you call setEditable( false ) to change an editable combobox to a
 non-editable one, the text completion object associated with the combobox will
 no longer exist unless you created the completion object yourself and assigned
 it to this widget or you called setAutoDeleteCompletionObject( false ). In other
 words do not do the following:
 <pre>
 KComboBox combo = new TDECompletionBox(true, this, "mywidget");
 TDECompletion comp = combo.completionObject();
 combo.setEditable( false );
 comp.clear(); // CRASH: completion object does not exist anymore.
 </pre>
 A read-only KComboBox will have the same background color as a
 disabled KComboBox, but its foreground color will be the one used for
 the read-write mode. This differs from TQComboBox's implementation
 and is done to give visual distinction between the three different modes:
 disabled, read-only, and read-write.
 <li><b>Usage </b></li>
 To enable the basic completion feature:
 <pre>
 KComboBox combo = new KComboBox( true, this, "mywidget" );
 TDECompletion comp = combo.completionObject();
 // Connect to the return pressed signal - optional
 connect(combo,TQ_SIGNAL("returnPressed(String)"),comp,TQ_SLOT("addItem(String)"));
 // Provide the to be completed strings. Note that those are separate from the combo's
 // contents.
 comp.insertItems( someArrayList );
 </pre>
 To use your own completion object:
 <pre>
 KComboBox combo = new KComboBox( this,"mywidget" );
 KURLCompletion comp = new KURLCompletion();
 combo.setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(combo,TQ_SIGNAL("returnPressed(String)"),comp,TQ_SLOT("addItem(String)"));
 </pre>
 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );
 Miscellaneous function calls:
 <pre>
 // Tell the widget not to handle completion and rotation
 combo.setHandleSignals( false );
 // Set your own completion key for manual completions.
 combo.setKeyBinding( TDECompletionBase.TextCompletion, Qt.End );
 // Hide the context (popup) menu
 combo.setContextMenuEnabled( false );
 </pre>
 See {@link KComboBoxSignals} for signals emitted by KComboBox
		@author Dawit Alemayehu <adawit@kde.org>

		@short An enhanced combo box.

*/
public class KComboBox extends TQComboBox implements TDECompletionBaseInterface {
	protected KComboBox(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a read-only or rather select-only combo box with a
		 parent object and a name.
			@param parent The parent object of this widget
			@param name The name of this widget
		    		@short    Constructs a read-only or rather select-only combo box with a  parent object and a name.
	*/
	public KComboBox(TQWidget parent, String name) {
		super((Class) null);
		newKComboBox(parent,name);
	}
	private native void newKComboBox(TQWidget parent, String name);
	public KComboBox(TQWidget parent) {
		super((Class) null);
		newKComboBox(parent);
	}
	private native void newKComboBox(TQWidget parent);
	public KComboBox() {
		super((Class) null);
		newKComboBox();
	}
	private native void newKComboBox();
	/**
		 Constructs a "read-write" or "read-only" combo box depending on
		 the value of the first argument( <code>rw</code> ) with a parent, a
		 name.
			@param rw When <code>true</code>, widget will be editable.
			@param parent The parent object of this widget.
			@param name The name of this widget.
		    		@short    Constructs a "read-write" or "read-only" combo box depending on  the value of the first argument( <code>rw</code> ) with a parent, a  name.
	*/
	public KComboBox(boolean rw, TQWidget parent, String name) {
		super((Class) null);
		newKComboBox(rw,parent,name);
	}
	private native void newKComboBox(boolean rw, TQWidget parent, String name);
	public KComboBox(boolean rw, TQWidget parent) {
		super((Class) null);
		newKComboBox(rw,parent);
	}
	private native void newKComboBox(boolean rw, TQWidget parent);
	public KComboBox(boolean rw) {
		super((Class) null);
		newKComboBox(rw);
	}
	private native void newKComboBox(boolean rw);
	/**
		 Sets <code>url</code> into the edit field of the combobox. It uses
		 KURL.prettyURL() so that the url is properly decoded for
		 displaying.
		     		@short    Sets <code>url</code> into the edit field of the combobox.
	*/
	public native void setEditURL(KURL url);
	/**
		 Inserts <code>url</code> at position <code>index</code> into the combobox. The item will
		 be appended if <code>index</code> is negative. KURL.prettyURL() is used
		 so that the url is properly decoded for displaying.
		     		@short    Inserts <code>url</code> at position <code>index</code> into the combobox.
	*/
	public native void insertURL(KURL url, int index);
	public native void insertURL(KURL url);
	/**
		 Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into
		 the combobox. The item will be appended if <code>index</code> is negative.
		 KURL.prettyURL() is used so that the url is properly decoded
		 for displaying.
		     		@short    Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into  the combobox.
	*/
	public native void insertURL(TQPixmap pixmap, KURL url, int index);
	public native void insertURL(TQPixmap pixmap, KURL url);
	/**
		 Replaces the item at position <code>index</code> with <code>url.</code>
		 KURL.prettyURL() is used so that the url is properly decoded
		 for displaying.
		     		@short    Replaces the item at position <code>index</code> with <code>url.</code>
	*/
	public native void changeURL(KURL url, int index);
	/**
		 Replaces the item at position <code>index</code> with <code>url</code> and pixmap <code>pixmap.</code>
		 KURL.prettyURL() is used so that the url is properly decoded
		 for displaying.
		     		@short    Replaces the item at position <code>index</code> with <code>url</code> and pixmap <code>pixmap.</code>
	*/
	public native void changeURL(TQPixmap pixmap, KURL url, int index);
	/**
		 Returns the current cursor position.
			 This method always returns a -1 if the combo-box is <b>not</b>
		 editable (read-write).
				@return Current cursor position.

		@short    Returns the current cursor position.
	*/
	public native int cursorPosition();
	/**
		 Re-implemented from TQComboBox.
			 If <code>true</code>, the completion mode will be set to automatic.
		 Otherwise, it is defaulted to the global setting.  This
		 method has been replaced by the more comprehensive
		 setCompletionMode().
			@param autocomplete Flag to enable/disable automatic completion mode.
		    		@short    Re-implemented from TQComboBox.
	*/
	public native void setAutoCompletion(boolean autocomplete);
	/**
		 Re-implemented from TQComboBox.
			 Returns <code>true</code> if the current completion mode is set
		 to automatic.  See its more comprehensive replacement
		 completionMode().
				@return <code>true</code> when completion mode is automatic.

		@short    Re-implemented from TQComboBox.
	*/
	public native boolean autoCompletion();
	/**
		 Enables or disable the popup (context) menu.
			 This method only works if this widget is editable, i.e.
		 read-write and allows you to enable/disable the context
		 menu.  It does nothing if invoked for a none-editable
		 combo-box.  Note that by default the mode changer item
		 is made visiable whenever the context menu is enabled.
		 Use hideModechanger() if you want to hide this
		 item.    Also by default, the context menu is created if
		 this widget is editable. Call this function with the
		 argument set to false to disable the popup menu.
			@param showMenu If <code>true</code>, show the context menu.
		    		@short    Enables or disable the popup (context) menu.
	*/
	public native void setContextMenuEnabled(boolean showMenu);
	/**
		 Returns <code>true</code> when the context menu is enabled.
		    		@short    Returns <code>true</code> when the context menu is enabled.
	*/
	public native boolean isContextMenuEnabled();
	/**
		 Enables/Disables handling of URL drops. If enabled and the user
		 drops an URL, the decoded URL will be inserted. Otherwise the default
		 behavior of TQComboBox is used, which inserts the encoded URL.
			@param enable If <code>true</code>, insert decoded URLs
		     		@short    Enables/Disables handling of URL drops.
	*/
	public native void setURLDropsEnabled(boolean enable);
	/**
		 Returns <code>true</code> when decoded URL drops are enabled
		     		@short    Returns <code>true</code> when decoded URL drops are enabled
	*/
	public native boolean isURLDropsEnabled();
	/**
		 Convenience method which iterates over all items and checks if
		 any of them is equal to <code>text.</code>
			 If <code>text</code> is an empty string, <code>false</code>
		 is returned.
				@return <code>true</code> if an item with the string <code>text</code> is in the combobox.

		@short    Convenience method which iterates over all items and checks if  any of them is equal to <code>text.</code>
	*/
	public native boolean contains(String text);
	/**
		 By default, KComboBox recognizes Key_Return and Key_Enter
		 and emits the returnPressed() signals, but it also lets the
		 event pass, for example causing a dialog's default-button to
		 be called.
			 Call this method with <code>trap</code> equal to true to make KComboBox
		 stop these events. The signals will still be emitted of course.
			 Only affects read-writable comboboxes.
				@short    By default, KComboBox recognizes Key_Return and Key_Enter  and emits the returnPressed() signals, but it also lets the  event pass, for example causing a dialog's default-button to  be called.
		@see #setTrapReturnKey
	*/
	public native void setTrapReturnKey(boolean trap);
	/**
				@return <code>true</code> if keyevents of Key_Return or Key_Enter will
 be stopped or if they will be propagated.

		@short
		@see #setTrapReturnKey
	*/
	public native boolean trapReturnKey();
	/**
		 Re-implemented for internal reasons.  API not affected.
		    		@short    Re-implemented for internal reasons.
	*/
	public native boolean eventFilter(TQObject arg1, TQEvent arg2);
	/**
			@param create Set this to false if you don't want the box to be created
		               i.e. to test if it is available.
		     		@return the completion-box, that is used in completion mode
 TDEGlobalSettings.CompletionPopup and TDEGlobalSettings.CompletionPopupAuto.
 This method will create a completion-box by calling
 KLineEdit.completionBox, if none is there, yet.

		@short
	*/
	public native TDECompletionBox completionBox(boolean create);
	public native TDECompletionBox completionBox();
	/**
		 Re-implemented for internal reasons.  API remains unaffected.
		 NOTE: Only editable comboboxes can have a line editor. As such
		 any attempt to assign a line-edit to a non-editable combobox will
		 simply be ignored.
		     		@short    Re-implemented for internal reasons.
	*/
	public native void setLineEdit(TQLineEdit arg1);
	/**
		 Iterates through all possible matches of the completed text
		 or the history list.
			 Depending on the value of the argument, this function either
		 iterates through the history list of this widget or the all
		 possible matches in whenever multiple matches result from a
		 text completion request.  Note that the all-possible-match
		 iteration will not work if there are no previous matches, i.e.
		 no text has been completed and the nix shell history list
		 rotation is only available if the insertion policy for this
		 widget is set either <code>TQComobBox</code>.AtTop or <code>TQComboBox</code>.AtBottom.
		 For other insertion modes whatever has been typed by the user
		 when the rotation event was initiated will be lost.
			@param type The key-binding invoked.
		    		@short    Iterates through all possible matches of the completed text  or the history list.
	*/
	public native void rotateText(int type);
	/**
		 Sets the completed text in the line-edit appropriately.
			 This function is an implementation for
		 TDECompletionBase.setCompletedText.
		     		@short    Sets the completed text in the line-edit appropriately.
	*/
	public native void setCompletedText(String arg1);
	/**
		 Sets <code>items</code> into the completion-box if completionMode() is
		 CompletionPopup. The popup will be shown immediately.
		     		@short    Sets <code>items</code> into the completion-box if completionMode() is  CompletionPopup.
	*/
	public native void setCompletedItems(String[] items);
	/**
		 Selects the first item that matches <code>item.</code> If there is no such item,
		 it is inserted at position <code>index</code> if <code>insert</code> is true. Otherwise,
		 no item is selected.
		     		@short    Selects the first item that matches <code>item.</code>
	*/
	public native void setCurrentItem(String item, boolean insert, int index);
	public native void setCurrentItem(String item, boolean insert);
	public native void setCurrentItem(String item);
	/**
		 Simply calls TQComboBox' implementation. Only here to not become
		 shadowed.
		     		@short    Simply calls TQComboBox' implementation.
	*/
	public native void setCurrentItem(int index);
	protected native void setCompletedText(String arg1, boolean arg2);
	/**
		 Reimplemented for internal reasons, the API is not affected.
		     		@short    Reimplemented for internal reasons, the API is not affected.
	*/
	protected native void create(long arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create(long arg1, boolean initializeWindow);
	protected native void create(long arg1);
	protected native void create();
	protected native void wheelEvent(TQWheelEvent ev);
	/**
		 Completes text according to the completion mode.
			 Note: this method is <code>not</code> invoked if the completion mode is
		 set to CompletionNone.  Also if the mode is set to <code>CompletionShell</code>
		 and multiple matches are found, this method will complete the
		 text to the first match with a beep to inidicate that there are
		 more matches.  Then any successive completion key event iterates
		 through the remaining matches.  This way the rotation functionality
		 is left to iterate through the list as usual.
		    		@short    Completes text according to the completion mode.
	*/
	protected native void makeCompletion(String arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
	/**
		 Returns a pointer to the current completion object.
			 If the completion object does not exist, it is automatically created and
		 by default handles all the completion signals internally unless <code>hsig</code>
		 is set to false. It is also automatically destroyed when the destructor
		 is called. You can change this default behavior using the
		 {@link #setAutoDeleteCompletionObject} and {@link #setHandleSignals} member
		 functions.
			 See also {@link #compObj}.
			@param hsig if true, handles completion signals internally.
				@return a pointer the completion object.

		@short    Returns a pointer to the current completion object.
	*/
	public native TDECompletion completionObject(boolean hsig);
	public native TDECompletion completionObject();
	/**
		 Sets up the completion object to be used.
			 This method assigns the completion object and sets it up to automatically
		 handle the completion and rotation signals internally.  You should use
		 this function if you want to share one completion object among your
		 widgets or need to use a customized completion object.
			 The object assigned through this method is not deleted when this object's
		 destructor is invoked unless you explicitly call {@link #setAutoDeleteCompletionObject}
		 after calling this method. Be sure to set the boolean argument to false, if
		 you want to handle the completion signals yourself.
			@param compObj a TDECompletion() or a derived child object.
			@param hsig if true, handles completion signals internally.
		     		@short    Sets up the completion object to be used.
	*/
	public native void setCompletionObject(TDECompletion compObj, boolean hsig);
	public native void setCompletionObject(TDECompletion compObj);
	/**
		 Enables this object to handle completion and rotation
		 events internally.
			 This function simply assigns a booleanean value that
		 indicates whether it should handle rotation and
		 completion events or not.  Note that this does not
		 stop the object from emitting signals when these
		 events occur.
			@param handle if true, handle completion & rotation internally.
		     		@short    Enables this object to handle completion and rotation  events internally.
	*/
	public native void setHandleSignals(boolean handle);
	/**
		 Returns true if the completion object is deleted
		 upon this widget's destruction.
			 See setCompletionObject() and enableCompletion()
		 for details.
				@return true if the completion object will be deleted
              automatically

		@short    Returns true if the completion object is deleted  upon this widget's destruction.
	*/
	public native boolean isCompletionObjectAutoDeleted();
	/**
		 Sets the completion object when this widget's destructor
		 is called.
			 If the argument is set to true, the completion object
		 is deleted when this widget's destructor is called.
			@param autoDelete if true, delete completion object on destruction.
		     		@short    Sets the completion object when this widget's destructor  is called.
	*/
	public native void setAutoDeleteCompletionObject(boolean autoDelete);
	/**
		 Sets the widget's ability to emit text completion and
		 rotation signals.
			 Invoking this function with <code>enable</code> set to <code>false</code> will
		 cause the completion & rotation signals not to be emitted.
		 However, unlike setting the completion object to <code>NULL</code>
		 using setCompletionObject, disabling the emition of
		 the signals through this method does not affect the current
		 completion object.
			 There is no need to invoke this function by default.  When a
		 completion object is created through completionObject or
		 setCompletionObject, these signals are set to emit
		 automatically.  Also note that disabling this signals will not
		 necessarily interfere with the objects ability to handle these
		 events internally.  See setHandleSignals.
			@param enable if false, disables the emition of completion & rotation signals.
		     		@short    Sets the widget's ability to emit text completion and  rotation signals.
	*/
	public native void setEnableSignals(boolean enable);
	/**
		 Returns true if the object handles the signals.
				@return true if this signals are handled internally.

		@short    Returns true if the object handles the signals.
	*/
	public native boolean handleSignals();
	/**
		 Returns true if the object emits the signals.
				@return true if signals are emitted

		@short    Returns true if the object emits the signals.
	*/
	public native boolean emitSignals();
	/**
		 Sets the type of completion to be used.
			 The completion modes supported are those defined in
		 TDEGlobalSettings().  See below.
			@param mode Completion type:

			<li>
			CompletionNone:  Disables completion feature.
			</li>

			<li>
			CompletionAuto:  Attempts to find a match &
			                        fills-in the remaining text.
			</li>

			<li>
			CompletionMan:   Acts the same as the above
			                        except the action has to be
			                        manually triggered through
			                        pre-defined completion key.
			</li>

			<li>
			CompletionShell: Mimics the completion feature
			                        found in typical nix shell
			                        environments.
			</li>

			<li>
			CompletionPopup: Shows all available completions at once,
			                        in a listbox popping up.

			</li>		@short    Sets the type of completion to be used.
	*/
	public native void setCompletionMode(int mode);
	/**
		 Returns the current completion mode.
			 The return values are of type TDEGlobalSettings.Completion.
		 See setCompletionMode() for details.
				@return the completion mode.

		@short    Returns the current completion mode.
	*/
	public native int completionMode();
	/**
		 Sets the key-binding to be used for manual text
		 completion, text rotation in a history list as
		 well as a completion list.
			 When the keys set by this function are pressed, a
		 signal defined by the inheriting widget will be activated.
		 If the default value or 0 is specified by the second
		 parameter, then the key-binding as defined in the global
		 setting should be used.  This method returns false value
		 for <code>key</code> is negative or the supplied key-binding conflicts
		 with the ones set for one of the other features.
			 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
		 the key-binding simply simply <code>sum</code> up the values of the
		 modifier and the actual key.  For example, to use CTRL+E as
		 a key binding for one of the items, you would simply supply
		 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
		 function.
			@param item the feature whose key-binding needs to be set:

			<li>
			TextCompletion the manual completion key-binding.
			</li>

			<li>
			PrevCompletionMatch    the previous match key for multiple completion.
			</li>

			<li>
			NextCompletionMatch    the next match key for for multiple completion.
			</li>

			<li>
			SubstringCompletion  the key for substring completion
			</li>
				@param key key-binding used to rotate down in a list.
				@return true if key-binding can successfully be set.

		@short    Sets the key-binding to be used for manual text  completion, text rotation in a history list as  well as a completion list.
		@see #getKeyBinding
	*/
	public native boolean setKeyBinding(int item, TDEShortcut key);
	/**
		 Returns the key-binding used for the specified item.
			 This methods returns the key-binding used to activate
		 the feature feature given by <code>item.</code>  If the binding
		 contains modifier key(s), the SUM of the modifier key
		 and the actual key code are returned.
			@param item the item to check
				@return the key-binding used for the feature given by <code>item.</code>

		@short    Returns the key-binding used for the specified item.
		@see #setKeyBinding
	*/
	public native TDEShortcut getKeyBinding(int item);
	/**
		 Sets this object to use global values for key-bindings.
			 This method changes the values of the key bindings for
		 rotation and completion features to the default values
		 provided in TDEGlobalSettings.
			 NOTE: By default inheriting widgets should uses the
		 global key-bindings so that there will be no need to
		 call this method.
		     		@short    Sets this object to use global values for key-bindings.
	*/
	public native void useGlobalKeyBindings();
	/**
		 Returns a pointer to the completion object.
			 This method is only different from completionObject()
		 in that it does not create a new TDECompletion object even if
		 the internal pointer is <code>NULL.</code> Use this method to get the
		 pointer to a completion object when inheriting so that you
		 won't inadvertently create it!!
				@return the completion object or NULL if one does not exist.

		@short    Returns a pointer to the completion object.
	*/
	public native TDECompletion compObj();
	/**
		 Returns a key-binding map.
			 This method is the same as getKeyBinding() except it
		 returns the whole keymap containing the key-bindings.
				@return the key-binding used for the feature given by <code>item.</code>

		@short    Returns a key-binding map.
	*/
	// TDECompletionBase::KeyBindingMap getKeyBindings(); >>>> NOT CONVERTED
	/**
		 Sets or removes the delegation object. If a delegation object is
		 set, all function calls will be forwarded to the delegation object.
			@param delegate the delegation object, or 0 to remove it
		     		@short    Sets or removes the delegation object.
	*/
	protected native void setDelegate(TDECompletionBaseInterface delegate);
	/**
		 Returns the delegation object.
				@return the delegation object, or 0 if there is none

		@short    Returns the delegation object.
		@see #setDelegate
	*/
	protected native TDECompletionBaseInterface delegate();
}
