/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;

class LineEdits  extends TQGroupBox
{
protected TQLineEdit lined1, lined2, lined3, lined4;
protected TQComboBox combo1, combo2, combo3, combo4;




/*
  Constructor
 *
  Creates child widgets of the LineEdits widget
 */

LineEdits( )
{
	this(null, null);
}

LineEdits( TQWidget parent, String name )
{
    super( 0, Horizontal, "Line edits", parent, name );
    setMargin( 10 );

    TQVBoxLayout box = new TQVBoxLayout( layout() );
    
    TQHBoxLayout row1 = new TQHBoxLayout( box );
    row1.setMargin( 5 );

    // Create a Label
    TQLabel label = new TQLabel( "Echo Mode: ", this);
    row1.addWidget( label );

    // Create a Combobox with three items...
    combo1 = new TQComboBox( false, this );
    row1.addWidget( combo1 );
    combo1.insertItem( "Normal", -1 );
    combo1.insertItem( "Password", -1 );
    combo1.insertItem( "No Echo", -1 );
    // ...and connect the activated() signal with the slotEchoChanged() slot to be able
    // to react when an item is selected
    connect( combo1, TQ_SIGNAL(" activated( int )"), this, TQ_SLOT(" slotEchoChanged( int )") );

    // insert the first LineEdit
    lined1 = new TQLineEdit( this );
    box.addWidget( lined1 );

    // another widget which is used for layouting
    TQHBoxLayout row2 = new TQHBoxLayout( box );
    row2.setMargin( 5 );

    // and the second label
    label = new TQLabel( "Validator: ", this );
    row2.addWidget( label );

    // A second Combobox with again three items...
    combo2 = new TQComboBox( false, this );
    row2.addWidget( combo2 );
    combo2.insertItem( "No Validator", -1 );
    combo2.insertItem( "Integer Validator", -1 );
    combo2.insertItem( "Double Validator", -1 );
    // ...and again the activated() signal gets connected with a slot
    connect( combo2, TQ_SIGNAL(" activated( int )"), this, TQ_SLOT(" slotValidatorChanged( int )") );

    // and the second LineEdit
    lined2 = new TQLineEdit( this );
    box.addWidget( lined2 );

    // yet another widget which is used for layouting
    TQHBoxLayout row3 = new TQHBoxLayout( box );
    row3.setMargin( 5 );

    // we need a label for this too
    label = new TQLabel( "Alignment: ", this );
    row3.addWidget( label );

    // A combo box for setting alignment
    combo3 = new TQComboBox( false, this );
    row3.addWidget( combo3 );
    combo3.insertItem( "Left", -1 );
    combo3.insertItem( "Centered", -1 );
    combo3.insertItem( "Right", -1 );
    // ...and again the activated() signal gets connected with a slot
    connect( combo3, TQ_SIGNAL(" activated( int )"), this, TQ_SLOT(" slotAlignmentChanged( int )") );

    // and the third lineedit
    lined3 = new TQLineEdit( this );
    box.addWidget( lined3 );

    // last widget used for layouting
    TQHBox row4 = new TQHBox( this );
    box.addWidget( row4 );
    row4.setMargin( 5 );

    // last label
    new TQLabel( "Read-Only: ", row4 );

    // A combo box for setting alignment
    combo4 = new TQComboBox( false, row4 );
    combo4.insertItem( "False", -1 );
    combo4.insertItem( "True", -1 );
    // ...and again the activated() signal gets connected with a slot
    connect( combo4, TQ_SIGNAL(" activated( int )"), this, TQ_SLOT(" slotReadOnlyChanged( int )") );

    // and the last lineedit
    lined4 = new TQLineEdit( this );
    box.addWidget( lined4 );

    // give the first LineEdit the focus at the beginning
    lined1.setFocus();
}

/*
  TQ_SLOT slotEchoChanged( int i )
 *
  i contains the number of the item which the user has been chosen in the
  first Combobox. According to this value, we set the Echo-Mode for the
  first LineEdit.
 */

void slotEchoChanged( int i )
{
    switch ( i ) {
    case 0:
	lined1.setEchoMode( TQLineEdit.Normal );
        break;
    case 1:
	lined1.setEchoMode( TQLineEdit.Password );
        break;
    case 2:
	lined1.setEchoMode( TQLineEdit.NoEcho );
        break;
    }

    lined1.setFocus();
}

/*
  TQ_SLOT slotValidatorChanged( int i )
 *
  i contains the number of the item which the user has been chosen in the
  second Combobox. According to this value, we set a validator for the
  second LineEdit. A validator checks in a LineEdit each character which
  the user enters and accepts it if it is valid, else the character gets
  ignored and not inserted into the lineedit.
 */

void slotValidatorChanged( int i )
{
    switch ( i ) {
    case 0:
	lined2.setValidator( null );
        break;
    case 1:
	lined2.setValidator( new TQIntValidator( lined2 ) );
        break;
    case 2:
	lined2.setValidator( new TQDoubleValidator( -999.0, 999.0, 2,
						    lined2 ) );
        break;
    }

    lined2.setText( "" );
    lined2.setFocus();
}


/*
  TQ_SLOT slotAlignmentChanged( int i )
 *
  i contains the number of the item which the user has been chosen in
  the third Combobox.  According to this value, we set an alignment
  third LineEdit.
 */

void slotAlignmentChanged( int i )
{
    switch ( i ) {
    case 0:
	lined3.setAlignment( TQLineEdit.AlignLeft );
        break;
    case 1:
	lined3.setAlignment( TQLineEdit.AlignCenter );
        break;
    case 2:
	lined3.setAlignment( TQLineEdit.AlignRight );
        break;
    }

    lined3.setFocus();
}


/*
  TQ_SLOT slotReadOnlyChanged( int i )
 *
  i contains the number of the item which the user has been chosen in
  the fourth Combobox.  According to this value, we toggle read-only.
 */

void slotReadOnlyChanged( int i )
{
    switch ( i ) {
    case 0:
	lined4.setReadOnly( false );
        break;
    case 1:
	lined4.setReadOnly( true );
        break;
    }

    lined4.setFocus();
}
}
