/*****************************************************************

Copyright (c) 2003 Aaron J. Seigo

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef PANELMENUITEMINFO_H
#define PANELMENUITEMINFO_H

#include <tqpopupmenu.h>
#include <tqstring.h>

#include <kiconloader.h>

// a little class meant to be used to store menu items for sorting then later
// plugging into a popup menu

class PanelMenuItemInfo
{
    public:
        PanelMenuItemInfo()
            : m_recvr(0), m_id(-1) {}

        PanelMenuItemInfo(const TQString& iconName, const TQString& visibleName, const TQObject* recvr, const TQCString& slot, int id = -1)
            : m_icon(iconName), m_name(visibleName), m_slot(slot), m_recvr(recvr), m_id(id) {}

        PanelMenuItemInfo(const TQString& iconName, const TQString& visibleName, int id = -1)
            : m_icon(iconName), m_name(visibleName), m_recvr(0), m_id(id) {}

        PanelMenuItemInfo(const PanelMenuItemInfo& c)
            : m_icon(c.m_icon), m_name(c.m_name), m_slot(c.m_slot), m_recvr(c.m_recvr), m_id(c.m_id) {}

        PanelMenuItemInfo& operator=(const PanelMenuItemInfo& c)
        {
            m_icon = c.m_icon;
            m_name = c.m_name;
            m_slot = c.m_slot;
            m_recvr = c.m_recvr;
            m_id = c.m_id;
            return *this;
        }

        bool operator<(const PanelMenuItemInfo& rh)
        {
            return m_name.lower() < rh.m_name.lower();
        }

        bool operator<=(const PanelMenuItemInfo& rh)
        {
            return m_name.lower() <= rh.m_name.lower();
        }

        bool operator>(const PanelMenuItemInfo& rh)
        {
            return m_name.lower() > rh.m_name.lower();
        }

        int plug(TQPopupMenu* menu)
        {
            if (!m_icon.isEmpty() && m_icon != "unknown")
            {
                if (m_recvr && !m_slot.isEmpty())
                {
                    return menu->insertItem(SmallIconSet(m_icon), m_name, m_recvr, m_slot, 0, m_id);
                }

                return menu->insertItem(SmallIconSet(m_icon), m_name, m_id);
            }
            else if (m_recvr && !m_slot.isEmpty())
            {
                return menu->insertItem(m_name, m_recvr, m_slot, 0, m_id);
            }

            return menu->insertItem(m_name, m_id);
        }

    private:
        TQString m_icon;
        TQString m_name;
        TQCString m_slot;
        const TQObject* m_recvr;
        int m_id;
};

#endif

