/*
 * Copyright 2015 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This file is part of hwdevicetray, the TDE Hardware Device Monitor System Tray Application
 *
 * hwdevicetray is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *
 * hwdevicetray is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with cryptocardwatcher. If not, see http://www.gnu.org/licenses/.
 */

#ifndef TDEHWDEVICETRAY_H
#define TDEHWDEVICETRAY_H

#include <ksystemtray.h>

class HwDeviceSystemTrayPrivate;
class KPassivePopup;
class TDEActionMenu;
class TDEGenericDevice;
class TDEGlobalAccel;
class TDEPopupMenu;
class TDEStorageDevice;

class HwDeviceSystemTray : public KSystemTray
{
	TQ_OBJECT

public:
	HwDeviceSystemTray(TQWidget* parent = 0, const char *name = 0);
	~HwDeviceSystemTray();

	TDEGlobalAccel *globalKeys;

	virtual void contextMenuAboutToShow(TDEPopupMenu *menu);

protected slots:
	void slotHardwareConfig();
	void slotEditShortcutKeys();
	void slotSettingsChanged(int category);
	void slotHelpContents();
	void slotExecuteDeviceAction(int parameter);

	void quitApp();
	void deviceAdded(TDEGenericDevice*);
	void deviceRemoved(TDEGenericDevice*);
	void deviceChanged(TDEGenericDevice*);
	void devicePopupClicked(KPassivePopup*, TQPoint, TQString);
	void doDiskNotifications(bool scanOnly);

protected:
	void initMenus();
	void mousePressEvent(TQMouseEvent *e);
	void populateLMBMenu();
	void resizeEvent(TQResizeEvent *);
	void resizeTrayIcon();
	void showEvent(TQShowEvent *);

	static bool isMonitoredDevice(TDEStorageDevice *sdevice);
	static TQString getDeviceLabel(TDEStorageDevice *sdevice);

	void addDeviceToLMBMenu(TDEStorageDevice *sdevice, const int type, TDEActionMenu *actionMenu,
	        int &actionMenuIdx);
	void addDeviceToRMBMenu(TDEStorageDevice *sdevice, const int type, int &actionMenuIdx);

	HwDeviceSystemTrayPrivate *d;
};

#endif
