/*
**
** Copyright (C) 2004 Richard Lrkng <nouseforaname@home.se>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

#ifndef GENTOOINTERFACE_H
#define GENTOOINTERFACE_H

#include "pkgInterface.h"

class Gentoo : public pkgInterface
{
  TQ_OBJECT
  

public:
  Gentoo();
  ~Gentoo();

  bool isType(char *buf, const TQString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const TQString &name, const TQString &version);
  TQStringList getFileList(packageInfo *p);
  TQStringList getChangeLog(packageInfo *p);

  bool filesTab(packageInfo *p);
  // If files tab is to be enabled

  bool changeTab(packageInfo *p);
  // If change log tab is to be enabled

  TQStringList FindFile(const TQString &name, bool seachAll=false);
  bool parseName(const TQString& name, TQString *n, TQString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInstalledInfo(const TQString& name, const TQString& category);
  packageInfo* collectUninstalledInfo(const TQString& name, const TQString& category, const TQString& version);
  void listInstalledPackages(TQPtrList<packageInfo> *pki);

  TQString install(int installFlags, TQPtrList<packageInfo> *plist, bool &test);
  TQString uninstall(int uninstallFlags, TQPtrList<packageInfo> *plist, bool &test);

  TQStringList archesPossible;
  TQString portageDir;
  TQStringList packageMask;
};


#endif // GENTOOINTERFACE_H
