#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

macro( tqt_message )
  message( STATUS "${ARGN}" )
endmacro( )

if( NOT TQT_FOUND )
  pkg_search_module( TQT tqt-mt )

  if( NOT TQT_FOUND )
    tde_message_fatal( "Unable to find tqt!\n Please make sure TQt is correctly installed." )
  endif( )

  # tqmoc executable
  pkg_get_variable( TQT_PREFIX tqt-mt prefix )
  find_program( TQMOC_EXECUTABLE NAMES tqmoc HINTS "${TQT_PREFIX}/bin" )
  if( NOT TQMOC_EXECUTABLE )
    tde_message_fatal( "tqmoc was not found.\n Please make sure TQt is correctly installed." )
  endif( )
  tqt_message( "  tqmoc path: ${TQMOC_EXECUTABLE}" )

  # tquic executable
  find_program( TQUIC_EXECUTABLE NAMES tquic HINTS "${TQT_PREFIX}/bin" )
  if( NOT EXISTS ${TQUIC_EXECUTABLE} )
    tde_message_fatal( "tquic was not found.\n Please make sure TQt is correctly installed." )
  endif( )
  tqt_message( "  tquic path: ${TQUIC_EXECUTABLE}" )

  # TQT_CMAKE_DIR
  if( NOT DEFINED TQT_CMAKE_DIR )
    set( TQT_CMAKE_DIR "${TQT_LIBDIR}/cmake"
         CACHE FILEPATH "Path for shared TQt CMake targets" )
  endif()

  # TQT_CXX_FLAGS
  foreach( _flag ${TQT_CFLAGS} ${TQT_CFLAGS_OTHER} )
    set( TQT_CXX_FLAGS "${TQT_CXX_FLAGS} ${_flag}" )
  endforeach()
  set( TQT_CXX_FLAGS "${TQT_CXX_FLAGS}" CACHE INTERNAL "" )

endif( NOT TQT_FOUND )

# Set compiler flags according to build type
set( CMAKE_CXX_FLAGS_RELWITHDEBINFO "-DNDEBUG" )
set( CMAKE_C_FLAGS_RELWITHDEBINFO   "-DNDEBUG" )
