/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_LYRICEDITDIALOG_H_
#define _RG_LYRICEDITDIALOG_H_

#include <kdialogbase.h>
#include <tqstring.h>
#include <vector>


class TQWidget;
class TQTextEdit;
class TQComboBox;
class TQPushButton;


namespace Rosegarden
{

class Segment;


class LyricEditDialog : public KDialogBase
{
    TQ_OBJECT
  

public:
    LyricEditDialog(TQWidget *parent, Segment *segment);

    int getVerseCount() const;
    TQString getLyricData(int verse) const;

protected slots:
    void slotVerseNumberChanged(int);
    void slotAddVerse();

protected:
    Segment *m_segment;

    int m_currentVerse;
    TQComboBox *m_verseNumber;
    TQTextEdit *m_textEdit;
    TQPushButton *m_verseAddButton;

    int m_verseCount;
    std::vector<TQString> m_texts;
    TQString m_skeleton;

    void countVerses();
    void unparse();
};

}

#endif
