/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_CHANGECOMPOSITIONLENGTHCOMMAND_H_
#define _RG_CHANGECOMPOSITIONLENGTHCOMMAND_H_

#include <kcommand.h>
#include <tqstring.h>
#include "base/Event.h"
#include <tdelocale.h>


class Change;


namespace Rosegarden
{

class Composition;


class ChangeCompositionLengthCommand : public KNamedCommand
{
public:
    ChangeCompositionLengthCommand(Composition *composition,
                                   timeT startTime,
                                   timeT endTime);
    virtual ~ChangeCompositionLengthCommand();

    static TQString getGlobalName()
        { return i18n("Change &Composition Start and End..."); }

    virtual void execute();
    virtual void unexecute();

protected:
    Composition *m_composition;
    timeT        m_startTime;
    timeT        m_endTime;
    timeT        m_oldStartTime;
    timeT        m_oldEndTime;

};


}

#endif
