/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "EventUnquantizeCommand.h"

#include <tdelocale.h>
#include "base/Quantizer.h"
#include "base/Segment.h"
#include "base/Selection.h"
#include "document/BasicCommand.h"
#include <tqstring.h>


namespace Rosegarden
{

EventUnquantizeCommand::EventUnquantizeCommand(Segment &segment,
        timeT startTime,
        timeT endTime,
        Quantizer *quantizer) :
        BasicCommand(i18n("Unquantize Events"), segment, startTime, endTime,
                     true),  // bruteForceRedo
        m_quantizer(quantizer),
        m_selection(0)
{
    // nothing else
}

EventUnquantizeCommand::EventUnquantizeCommand(
    EventSelection &selection,
    Quantizer *quantizer) :
        BasicCommand(i18n("Unquantize Events"),
                     selection.getSegment(),
                     selection.getStartTime(),
                     selection.getEndTime(),
                     true),  // bruteForceRedo
        m_quantizer(quantizer),
        m_selection(&selection)
{
    // nothing else
}

EventUnquantizeCommand::~EventUnquantizeCommand()
{
    delete m_quantizer;
}

TQString
EventUnquantizeCommand::getGlobalName(Quantizer *)
{
    /*!!!
        if (quantizer) {
    	switch (quantizer->getType()) {
    	case Quantizer::PositionQuantize:
    	    return i18n("Position &Quantize");
    	case Quantizer::UnitQuantize:
    	    return i18n("Unit &Quantize");
    	case Quantizer::NoteQuantize:
    	    return i18n("Note &Quantize");
    	case Quantizer::LegatoQuantize:
    	    return i18n("Smoothing &Quantize");
    	}
        }
    */ 
    return i18n("&Quantize...");
}

void
EventUnquantizeCommand::modifySegment()
{
    Segment &segment = getSegment();

    if (m_selection) {

        m_quantizer->unquantize(m_selection);

    } else {
        m_quantizer->unquantize(&segment,
                                segment.findTime(getStartTime()),
                                segment.findTime(getEndTime()));
    }
}

}
