/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITMATRIXVECTORDIALOG_H
#define QALCULATEEDITMATRIXVECTORDIALOG_H

#include <kdialogbase.h>

class TQLabel;
class TQSpinBox;
class TQTable;
class TQRadioButton;
class KComboBox;
class KLineEdit;
class TQPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class KnownVariable;

/**
@author Niklas Knutsson
*/
class QalculateEditMatrixVectorDialog : public KDialogBase {

	TQ_OBJECT

public:

	QalculateEditMatrixVectorDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditMatrixVectorDialog();

	KnownVariable *newMatrix(TQString category = TQString::null);
	KnownVariable *newVector(TQString category = TQString::null);
	KnownVariable *editVariable(TQString category = TQString::null, KnownVariable *v = NULL, MathStructure *initial_value = NULL, bool force_value = false, bool create_vector = false);

	QalculateEditNamesDialog *names_edit_dialog;
	KnownVariable *edited_variable;
	KComboBox *categoryCombo;
	KLineEdit *nameEdit, *titleEdit;
	TQLabel *namesLabel, *elementsLabel;
	TQRadioButton *matrixButton, *vectorButton;
	TQTable *elementsTable;
	TQSpinBox *rowsBox, *columnsBox;
	TQPushButton *namesButton;

private:

	MathStructure *init_value;
	bool force_init_value;

public slots:

	void typeChanged(int);
	void rowsChanged(int);
	void columnsChanged(int);
	void editNames();
	void nameChanged(const TQString&);
	
protected slots:
	
	void slotHelp();
	void slotOk();

};

#endif
