#!/usr/bin/env python

# A simple application.


import sys, string
from PyTQt.tqt import *


fileopen = [
    '16 13 5 1',
    '. c #040404',
    '# c #808304',
    'a c None',
    'b c #f3f704',
    'c c #f3f7f3',
    'aaaaaaaaa...aaaa',
    'aaaaaaaa.aaa.a.a',
    'aaaaaaaaaaaaa..a',
    'a...aaaaaaaa...a',
    '.bcb.......aaaaa',
    '.cbcbcbcbc.aaaaa',
    '.bcbcbcbcb.aaaaa',
    '.cbcb...........',
    '.bcb.#########.a',
    '.cb.#########.aa',
    '.b.#########.aaa',
    '..#########.aaaa',
    '...........aaaaa'
]

filesave = [
    '14 14 4 1',
    '. c #040404',
    '# c #808304',
    'a c #bfc2bf',
    'b c None',
    '..............',
    '.#.aaaaaaaa.a.',
    '.#.aaaaaaaa...',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.#.aaaaaaaa.#.',
    '.##........##.',
    '.############.',
    '.##.........#.',
    '.##......aa.#.',
    '.##......aa.#.',
    '.##......aa.#.',
    'b.............'
]

fileprint = [
    '16 14 6 1',
    '. c #000000',
    '# c #848284',
    'a c #c6c3c6',
    'b c #ffff00',
    'c c #ffffff',
    'd c None',
    'ddddd.........dd',
    'dddd.cccccccc.dd',
    'dddd.c.....c.ddd',
    'ddd.cccccccc.ddd',
    'ddd.c.....c....d',
    'dd.cccccccc.a.a.',
    'd..........a.a..',
    '.aaaaaaaaaa.a.a.',
    '.............aa.',
    '.aaaaaa###aa.a.d',
    '.aaaaaabbbaa...d',
    '.............a.d',
    'd.aaaaaaaaa.a.dd',
    'dd...........ddd'
]

document = [
"12 16 6 1",
"       c #040404",
".      c None",
"X      c white",
"o      c #808304",
"O      c black",
"+      c #f3f7f3",
"       .....",
" XXXXX  ....",
" XXXXX X ...",
" XXXXX XX ..",
" XooXX    O.",
" X+XXX+XXXO.",
" XXXXXXXXXO.",
" XoooXooXXO.",
" XXXXXXXXXO.",
" XXXXXXXXXO.",
" XoXXoooXXO.",
" XXXXXXXXXO.",
"OXXXXXXXXXO.",
"OXXXXXXXXXO.",
"OOOOOOOOOOO.",
"............"
]

fileOpenText = \
'''<img source="fileopen">
Click this button to open a <em>new file</em>.<br><br>
You can also select the <b>Open</b> command from the <b>File</b> menu.'''

fileSaveText = \
'''Click this button to save the file you are editing.<br><br>
You will be prompted for a filename.<br><br>
You can also select the <b>Save</b> command from the <b>File</b> menu.'''

filePrintText = \
'''Click this button to print the file you are editing.<br><br>
You can also select the <b>Print</b> command from the <b>File</b> menu.'''

#True=1
#False=0

class ApplicationWindow(TQMainWindow):
    def __init__(self):
        TQMainWindow.__init__(self,None,'example application main window',TQt.WDestructiveClose)

        self.filename = TQString.null
        self.printer = TQPrinter()

        self.fileTools = TQToolBar(self,'file operations')

        openIcon = TQPixmap(fileopen)
        self.fileOpen = TQToolButton(TQIconSet(openIcon),'Open File',TQString.null,self.load,self.fileTools,'open file')

        saveIcon = TQPixmap(filesave)
        self.fileSave = TQToolButton(TQIconSet(saveIcon),'Save File',TQString.null,self.save,self.fileTools,'save file')
        printIcon = TQPixmap(fileprint)
        self.filePrint = TQToolButton(TQIconSet(printIcon),'Print File',TQString.null,self.printDoc,self.fileTools,'print file')

        TQWhatsThis.whatsThisButton(self.fileTools)

        TQWhatsThis.add(self.fileOpen,fileOpenText)
        TQMimeSourceFactory.defaultFactory().setPixmap('fileopen',openIcon)
        TQWhatsThis.add(self.fileSave,fileSaveText)
        TQWhatsThis.add(self.filePrint,filePrintText)

        self.file = TQPopupMenu(self)
        self.menuBar().insertItem('&File',self.file)

        self.file.insertItem('&New',self.newDoc,TQt.CTRL + TQt.Key_N)

        id = self.file.insertItem(TQIconSet(openIcon),'&Open',self.load,TQt.CTRL + TQt.Key_O)
        self.file.setWhatsThis(id,fileOpenText)

        id = self.file.insertItem(TQIconSet(saveIcon),'&Save',self.save,TQt.CTRL + TQt.Key_S)
        self.file.setWhatsThis(id,fileSaveText)

        id = self.file.insertItem('Save &as',self.saveAs)
        self.file.setWhatsThis(id,fileSaveText)

        self.file.insertSeparator()

        id = self.file.insertItem(TQIconSet(printIcon),'&Print',self.printDoc,TQt.CTRL + TQt.Key_P)
        self.file.setWhatsThis(id,filePrintText)

        self.file.insertSeparator()

        self.file.insertItem('&Close',self,TQ_SLOT('close()'),TQt.CTRL + TQt.Key_W)
        self.file.insertItem('&Quit',tqApp,TQ_SLOT('closeAllWindows()'),TQt.CTRL + TQt.Key_Q)

        self.menuBar().insertSeparator()
        self.windows = TQPopupMenu( self )
        self.windows.setCheckable( True )
        self.connect( self.windows, TQ_SIGNAL( "aboutToShow()" ),
        self.windowsMenuAboutToShow )
        self.menuBar().insertItem( "&Windows", self.windows )

        self.help = TQPopupMenu(self)
        self.menuBar().insertSeparator()
        self.menuBar().insertItem('&Help',self.help)

        self.help.insertItem('&About',self.about,TQt.Key_F1)
        self.help.insertItem('About &TQt',self.aboutTQt)
        self.help.insertSeparator()
        self.help.insertItem( "What's &This", self, TQ_SLOT("whatsThis()"), TQt.SHIFT+TQt.Key_F1)

        self.menuBar().insertSeparator()

        self.vb = TQVBox( self )
        self.vb.setFrameStyle( TQFrame.StyledPanel | TQFrame.Sunken )
        self.ws = TQWorkspace( self.vb )
        self.ws.setScrollBarsEnabled( True )
        self.setCentralWidget( self.vb )

        self.statusBar().message('Ready',2000)
        #self.resize(450,600)

    def newDoc(self):
        w = MDIWindow( self.ws, "", TQt.WDestructiveClose )
        self.connect( w, PYSIGNAL( "message" ), self.statusBar(), TQ_SLOT( "message(const TQString&, int )") )
        w.setCaption("unnamed document")
        w.setIcon( TQPixmap(document) )
        # show the very first window in maximized mode
        if len(self.ws.windowList())==0:
            w.showMaximized()
        else:
            w.show()
        return w

    def load(self):
        fn = TQFileDialog.getOpenFileName( TQString.null, TQString.null, self )
        if not fn.isEmpty():
            w = self.newDoc()
            w.load( fn )
        else:
            self.statusBar().message( "Loading aborted", 2000 )

    def save(self):
        m = self.ws.activeWindow()
        if m:
            m.save()

    def saveAs(self):
        m = self.ws.activeWindow()
        if m:
            m.saveAs()

    def printDoc(self):
        m = self.ws.activeWindow()
        if m:
            m.printDoc( self.printer )

    def closeWindow(self):
        m = self.ws.activeWindow()
        if m:
            m.close()

    def about(self):
        TQMessageBox.about( self, "TQt Application Example",
            "This example demonstrates simple use of\n "
            "TQt's Multiple Document Interface (MDI).")

    def aboutTQt(self):
        TQMessageBox.aboutTQt( self, "TQt Application Example" )

    def windowsMenuAboutToShow(self):
        self.windows.clear()
        cascadeId = self.windows.insertItem("&Cascade", self.ws, TQ_SLOT("cascade() ") )
        tileId = self.windows.insertItem("&Tile", self.ws, TQ_SLOT("tile()" ) )
        if len(self.ws.windowList())==0 :
            self.windows.setItemEnabled( cascadeId, False )
            self.windows.setItemEnabled( tileId, False )
        self.windows.insertSeparator()
        windows = self.ws.windowList()
        cnt=0
        for i in windows:
            id =self.windows.insertItem(i.caption(),self.windowsMenuActivated )
            self.windows.setItemParameter( id, cnt );
            self.windows.setItemChecked( id, self.ws.activeWindow() == i )
            cnt=cnt+1

    def windowsMenuActivated(self,sid ):
        w = self.ws.windowList().at( id )
        if w:
            w.showNormal()
            w.setFocus()


class MDIWindow( TQMainWindow):
        def __init__(self,parent, name, wflags ):
                TQMainWindow.__init__(self,parent, name, wflags )
                self.mmovie = 0
                self.medit = TQMultiLineEdit( self )
                self.setFocusProxy( self.medit )
                self.setCentralWidget( self.medit );


        def load(self, fn ):
                self.filename  = fn
                self.f=TQFile( self.filename )
                if not self.f.open( IO_ReadOnly ):
                        return

                if fn.contains(".gif"):
                        tmp=TQWidget(self)
                        self.setFocusProxy(tmp)
                        self.setCentralWidget(tmp)
                        self.medit.hide()
                        del self.medit
                        qm=TQMovie(fn)
                        #ifdef TQ_WS_QWS // temporary speed-test hack
                        #qm->setDisplayWidget(tmp);
                        #endif
                        tmp.setBackgroundMode(TQWidget.NoBackground)
                        tmp.show()
                        self.mmovie=qm
                else :
                        self.mmovie = 0
                        t=TQTextStream(self.f)
                        s = t.read()
                        self.medit.setText( s )
                        self.f.close()
                self.setCaption( self.filename )
                self.emit(PYSIGNAL( "message"),(TQString("Loaded document %1").arg(self.filename),2000 ))

        def save(self):
                if self.filename.isEmpty():
                        self.saveAs()
                        return
                text = self.medit.text()
                output=open(str(self.filename),'w')
                output.write(str(text))
                #emit message( TQString("Could not write to %1").arg(filename), 2000 );
                #return
                output.close()
                self.setCaption(self.filename)
                self.emit(PYSIGNAL( "message"),(TQString("File %1 saved").arg(self.filename),2000 ))

        def saveAs(self):
                fn = TQFileDialog.getSaveFileName( self.filename, TQString.null, self )
                if not fn.isEmpty():
                        self.filename = fn
                        self.save()
                else :
                        self.emit(PYSIGNAL( "message"),(TQString("Saving aborted"),2000 ))

        def printDoc(self,printer):
                Margin = 10
                pageNo = 1

                if printer.setup(self):
                        self.emit(PYSIGNAL( "message"),(TQString("Printing..."),2000 ))
                        p = TQPainter()
                        p.begin(printer)
                        p.setFont(self.medit.font())
                        yPos = 0
                        fm = p.fontMetrics()
                        metrics = TQPaintDeviceMetrics(printer)

                        for i in range(self.medit.numLines()):
                                if Margin + yPos > metrics.height() - Margin:
                                        pageNo = pageNo + 1
                                        self.emit(PYSIGNAL( "message"),(TQString("Printing (page %1) ...").arg(pageNo),2000 ))
                                        printer.newPage()
                                        yPos = 0

                                p.drawText(Margin,Margin + yPos,metrics.width(),fm.lineSpacing(),TQt.ExpandTabs | TQt.DontClip,self.medit.textLine(i))
                                yPos = yPos + fm.lineSpacing()

                        p.end()
                        self.emit(PYSIGNAL( "message"),(TQString("Printing completed"),2000 ))
                else:
                        self.emit(PYSIGNAL( "message"),(TQString("Printing aborted"),2000 ))


if __name__=='__main__':
    a = TQApplication(sys.argv)
    mw = ApplicationWindow()
    mw.setCaption("PyTQt Example - Multiple Documents Interface (MDI)")
    mw.show()
    a.connect(a, TQ_SIGNAL('lastWindowClosed()'), a, TQ_SLOT('quit()'))
    a.exec_loop()
