/**
   File : xsldbginspector.cpp
   Author : Keith Isdale
   Date : 30th March 2002
   Description : Dialog to inspect stylesheet using xsldbg. Based on
                  file created by uic
 */

#include "xsldbginspector.h"

#include <tdelocale.h>

#include <tqvariant.h>
#include <tqlistbox.h>
#include <tqpushbutton.h>
#include <tqtabwidget.h>
#include <tqwidget.h>
#include <tqmime.h>
#include <tqdragobject.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqiconset.h>

#include <kpushbutton.h>
#include <kstdguiitem.h>
#include "xsldbgdebugger.h"
#include "xsldbgbreakpointsimpl.h"
#include "xsldbglocalvariablesimpl.h"
#include "xsldbgcallstackimpl.h"
#include "xsldbgtemplatesimpl.h"
#include "xsldbgsourcesimpl.h"
#include "xsldbgentitiesimpl.h"

static TQPixmap uic_load_pixmap_XsldbgInspector( const TQString &name )
{
    const TQMimeSource *m = TQMimeSourceFactory::defaultFactory()->data( name );
    if ( !m )
	return TQPixmap();
    TQPixmap pix;
    TQImageDrag::decode( m, pix );
    return pix;
}
/*
 *  Constructs a XsldbgInspector which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  true to construct a modal dialog.
 */
XsldbgInspector::XsldbgInspector( XsldbgDebugger *debugger, TQWidget* parent,
				  const char* name, bool modal, WFlags fl )
    : TQDialog( parent, name, modal, fl )
{
    TQ_CHECK_PTR(debugger);
    this->debugger = debugger;
    breakpointWidget = 0L;
    localWidget = 0L;
    callStackWidget = 0L;
    templateWidget = 0L;
    sourceWidget = 0L;
    entityWidget = 0L;
    if ( !name )
	setName( "XsldbgInspector" );
    resize( 597, 364 );
    setCaption( i18n( "Xsldbg Inspector" ) );
    setSizeGripEnabled( true );
    XsldbgInspectorLayout = new TQGridLayout( this, 1, 1, 11, 6,
					     "XsldbgInspectorLayout");

    tabWidget = new TQTabWidget( this, "tabWidget" );
    TQ_CHECK_PTR( tabWidget );
    breakpointWidget = new XsldbgBreakpointsImpl( debugger, tabWidget );
    TQ_CHECK_PTR( breakpointWidget );
    tabWidget->insertTab( breakpointWidget, i18n( "Breakpoints" ) );

    localWidget = new  XsldbgLocalVariablesImpl( debugger, tabWidget );
    TQ_CHECK_PTR( localWidget );
    tabWidget->insertTab( localWidget,
	  TQIconSet( uic_load_pixmap_XsldbgInspector( "xsldbg_source.png" ) ),
	  i18n( "Variables" ) );

    callStackWidget = new  XsldbgCallStackImpl( debugger, tabWidget );
    TQ_CHECK_PTR( callStackWidget );
    tabWidget->insertTab( callStackWidget,
	  TQIconSet( uic_load_pixmap_XsldbgInspector( "xsldbg_source.png" ) ),
	  i18n( "CallStack" ));

    templateWidget = new  XsldbgTemplatesImpl( debugger, tabWidget );
    TQ_CHECK_PTR( templateWidget );
    tabWidget->insertTab( templateWidget,
	  TQIconSet( uic_load_pixmap_XsldbgInspector( "xsldbg_source.png" ) ),
          i18n( "Templates" ));

    sourceWidget = new  XsldbgSourcesImpl( debugger, tabWidget );
    TQ_CHECK_PTR( sourceWidget );
    tabWidget->insertTab( sourceWidget,
	  TQIconSet( uic_load_pixmap_XsldbgInspector( "xsldbg_source.png" ) ),
	  i18n( "Sources" ));

    entityWidget = new  XsldbgEntitiesImpl( debugger, tabWidget );
    TQ_CHECK_PTR( entityWidget );
    tabWidget->insertTab( entityWidget,
	  TQIconSet( uic_load_pixmap_XsldbgInspector( "xsldbg_data.png" ) ),
	  i18n( "Entities" ));

    XsldbgInspectorLayout->addWidget( tabWidget, 0, 1 );
    Layout1 = new TQHBoxLayout( 0, 0, 6, "Layout1");

    buttonHelp = new KPushButton( KStdGuiItem::help(), this, "buttonHelp" );
    buttonHelp->setAccel( 4144 );
    buttonHelp->setAutoDefault( true );
    Layout1->addWidget( buttonHelp );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new KPushButton( KStdGuiItem::ok(), this, "buttonOk" );
    buttonOk->setAccel( 0 );
    buttonOk->setAutoDefault( true );
    buttonOk->setDefault( true );
    Layout1->addWidget( buttonOk );

    buttonApply = new KPushButton( KStdGuiItem::apply(), this, "buttonApply" );
    TQToolTip::add(buttonApply, i18n("Apply changes to xsldbg after restarting execution"));
    buttonApply->setAccel( 0 );
    buttonApply->setAutoDefault( true );
    buttonApply->setDefault( true );
    Layout1->addWidget( buttonApply );

    buttonRefresh = new TQPushButton( this, "buttonRefresh" );
    buttonRefresh->setText( i18n( "&Refresh" ) );
    TQToolTip::add(buttonRefresh, i18n("Refresh values in inspectors from xsldbg"));
    buttonRefresh->setAccel( 0 );
    buttonRefresh->setAutoDefault( true );
    buttonRefresh->setDefault( true );
    Layout1->addWidget( buttonRefresh );

    buttonCancel = new KPushButton( KStdGuiItem::cancel(), this, "buttonCancel" );
    buttonCancel->setAccel( 0 );
    buttonCancel->setAutoDefault( true );
    Layout1->addWidget( buttonCancel );

    XsldbgInspectorLayout->addMultiCellLayout( Layout1, 1, 1, 0, 1 );

    // signals and slots connections
    connect( buttonOk, TQ_SIGNAL( clicked() ), this, TQ_SLOT( accept() ) );
    connect( buttonApply, TQ_SIGNAL ( clicked() ), this, TQ_SLOT ( update() ) );
    connect( buttonRefresh, TQ_SIGNAL ( clicked() ), this, TQ_SLOT ( refresh() ) );
    connect( buttonCancel, TQ_SIGNAL( clicked() ), this, TQ_SLOT( reject() ) );

    hide();
}

/*
 *  Destroys the object and frees any allocated resources
 */
XsldbgInspector::~XsldbgInspector()
{
  debugger = 0L;
  // no need to delete child widgets, TQt does it all for us
}


void XsldbgInspector::accept()
{
  TQDialog::accept();
}

void XsldbgInspector::reject()
{
  TQDialog::reject();
}


void XsldbgInspector::refresh()
{

  refreshBreakpoints();
  refreshVariables();

  if ( templateWidget != 0L)
    templateWidget->refresh();

  if ( sourceWidget != 0L)
    sourceWidget->refresh();

  if ( entityWidget != 0L)
    entityWidget->refresh();

}

void XsldbgInspector::refreshBreakpoints()
{
    if ( breakpointWidget != 0L )
      breakpointWidget->refresh();
}


void XsldbgInspector::refreshVariables()
{
    if ( localWidget != 0L )
      localWidget->refresh();

    if (callStackWidget != 0L)
      callStackWidget->refresh();
}

#include "xsldbginspector.moc"
