//=============================================================================
//
//   File : kvi_htmldialog.cpp
//   Created on Wed 03 Jan 2007 03:36:36 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
#define __KVIRC__

#include "kvi_htmldialog.h"
#include "kvi_locale.h"
#include "kvi_tal_textedit.h"

#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqtextbrowser.h>

KviHtmlDialog::KviHtmlDialog(TQWidget * pParent,KviHtmlDialogData * pData)
: TQDialog(pParent)
{
	m_pData = pData;

	if(pData->szCaption.isEmpty())
		setCaption("KVIrc");
	else
		setCaption(pData->szCaption);
		
	if(!pData->pixIcon.isNull())
		setIcon(pData->pixIcon);

	TQGridLayout * g = new TQGridLayout(this,4,3,7,7);
	
	TQLabel * l;
	TQTextBrowser * te;
	TQPushButton * pb;
	
	int iUp = 0;
	int iDown = 2;

	if(!pData->szUpperLabelText.isEmpty())
	{
		l = new TQLabel(this);
		l->setText(pData->szUpperLabelText);
		g->addMultiCellWidget(l,0,0,0,2);
		iUp = 1;
	}

	if(!pData->szLowerLabelText.isEmpty())
	{
		l = new TQLabel(this);
		l->setText(pData->szLowerLabelText);
		g->addMultiCellWidget(l,2,2,0,2);
		iDown = 1;
	}

	te = new TQTextBrowser(this);
	te->setText(pData->szHtmlText);
	//te->setReadOnly(true);

	if(pData->iFlags & KviHtmlDialogData::ForceMinimumSize)
		te->setMinimumSize(pData->iMinimumWidth,pData->iMinimumHeight);

	//te->setReadOnly(true);
	g->addMultiCellWidget(te,iUp,iDown,0,2);

	int iButtons = pData->szButton3Text.isEmpty() ? (pData->szButton2Text.isEmpty() ? 1 : 2) : 3;
	if(pData->iCancelButton > iButtons)pData->iCancelButton = iButtons;
	if(pData->iDefaultButton > iButtons)pData->iDefaultButton = iButtons;

	pb = new TQPushButton(this);
	pb->setText(pData->szButton1Text.isEmpty() ? __tr2qs("OK") : pData->szButton1Text);
	pb->setDefault(pData->iDefaultButton == 1);
	int iCoord = iButtons == 1 ? 1 : 0;
	g->addWidget(pb,3,iCoord);
	connect(pb,TQ_SIGNAL(clicked()),this,TQ_SLOT(button1Pressed()));

	if(!pData->szButton2Text.isEmpty())
	{
		pb = new TQPushButton(this);
		pb->setText(pData->szButton2Text);
		pb->setDefault(pData->iDefaultButton == 2);
		iCoord = iButtons == 2 ? 2 : 1;
		g->addWidget(pb,3,iCoord);
		connect(pb,TQ_SIGNAL(clicked()),this,TQ_SLOT(button2Pressed()));

		if(!pData->szButton3Text.isEmpty())
		{
			pb = new TQPushButton(this);
			pb->setText(pData->szButton3Text);
			pb->setDefault(pData->iDefaultButton == 3);
			g->addWidget(pb,3,2);
			connect(pb,TQ_SIGNAL(clicked()),this,TQ_SLOT(button3Pressed()));
		}
	}

	g->setRowStretch(1,1);

	m_pData->iSelectedButton = m_pData->iDefaultButton;
}

KviHtmlDialog::~KviHtmlDialog()
{
	
}

void KviHtmlDialog::button1Pressed()
{
	m_pData->iSelectedButton = 1;
	accept();
}

void KviHtmlDialog::button2Pressed()
{
	m_pData->iSelectedButton = 2;
	accept();
}

void KviHtmlDialog::button3Pressed()
{
	m_pData->iSelectedButton = 3;
	accept();
}

void KviHtmlDialog::reject()
{
	m_pData->iSelectedButton = m_pData->iCancelButton;
	TQDialog::reject();
}

int KviHtmlDialog::display(TQWidget * pParent,KviHtmlDialogData * pData)
{
	KviHtmlDialog * pDialog = new KviHtmlDialog(pParent,pData);
	pDialog->exec();
	delete pDialog;
	return pData->iSelectedButton;
}

#include "kvi_htmldialog.moc"
