/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Jun 19 14:43:55 BST 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <tdecrash.h>
#include <kdebug.h>
#include <tdeuniqueapplication.h>

#include <stdio.h>
#include <stdlib.h>
#include <tdemessagebox.h>

#include "kooldock.h"

#define KOOLDOCK_VERSION "0.4.7"
TQString argv0;

#ifndef _ENABLE_DEBUG
extern "C"
{
  static void crashHandler(int /*signal*/)
  {
    char cmd[1024];
    fprintf(stderr, "kooldock: crashHandler called\n");
    snprintf(cmd, 1023, "%s &", argv0.ascii());
    int status = system(cmd); // try to restart according to argv[0]
    status++;
  }
}
#endif

static const char *description = I18N_NOOP("<center><b>KoolDock</b></center>A Kool Dock for TDE<br><br>KoolDock is based upon the original work of Dang Viet Dung, Ksmoothdock 2.1<br><br>");

static TDECmdLineOptions options[] =
{
   { "o", 0, 0 },
   { "options", I18N_NOOP("Show configuration window on start"), 0 },
   { "k", 0, 0 },
   { "kill", I18N_NOOP("Kills all processes called Kooldock"), 0 },
   {0, 0, 0}
};

int main(int argc, char *argv[])
{
   argv0 = TQString("%1").arg(argv[0]);

   TDEAboutData aboutData("kooldock", I18N_NOOP("KoolDock"),
                          KOOLDOCK_VERSION, description, TDEAboutData::License_GPL,
                          "(c) 2003, 2006 - KoolDock team", 0, "http://ktown.kde.cl/kooldock", "kooldock-devel@lists.kde.cl");
   aboutData.addAuthor("Matias Fernandez",0, "radix@kde.cl");
   aboutData.addAuthor("Francisco Guidi",0, "francisco@guidi.com", "http://francisco.guidi.com");
   aboutData.addAuthor("Blase Stanek", 0, "bisiek@op.pl");
   aboutData.addCredit("Mauricio Bahamonde", I18N_NOOP("Project Webmaster"), "elkrammer@kde.cl", "http://ktown.kde.cl/~elkrammer/");
   aboutData.addCredit("Sebastian Sariego Benitez", I18N_NOOP("Icon and artwork"), "segfault@powers.cl", "http://segfault.kde.cl");
   aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));
   TDECmdLineArgs::init( argc, argv, &aboutData );
   TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.
   
   #ifdef _ENABLE_DEBUG
   TDEApplication::addCmdLineOptions();
   #endif
   #ifndef _ENABLE_DEBUG
   TDEUniqueApplication::addCmdLineOptions();
   #endif
   if ((TQString("%1").arg(argv[1]) == "-kill") || (TQString("%1").arg(argv[1]) == "-k")) {
	   int status = system("killall kooldock");
     status++;
	   exit(0);
   } 
   
   #ifndef _ENABLE_DEBUG
   if (!TDEUniqueApplication::start()) {
    fprintf(stderr, "Kooldock is already running!\n");
    exit(0);
   }
   #endif
  
   #ifndef _ENABLE_DEBUG
   TDEUniqueApplication a;
   #endif
   #ifdef _ENABLE_DEBUG
   TDEApplication a;
   #endif
   KoolDock* kooldock = new KoolDock();
   a.setMainWidget(kooldock);

   #ifndef _ENABLE_DEBUG
   if (TDECrash::crashHandler() !=0 ) {
     kdDebug(0) << "Installing crash handler" << endl;
     TDECrash::setEmergencySaveFunction(crashHandler); // Try to restart on crash
   }
   #endif
   
   kooldock->setMainPath(argv0);
   kooldock->setArgs(TQString("%1").arg(argv[1]));
   return a.exec();
}
