#include "clip.h"

#include <tqwidget.h>
#include <tqbitmap.h>
#include <tqpainter.h>
#include <netwm.h>
#include <netwm_def.h>
#include <twin.h>

#include <kdebug.h>

clip::clip(TQWidget* parent,
           const char* name) :
  TQWidget(parent, name,
           WStyle_Customize | WStyle_NoBorder | WNoAutoErase | WDestructiveClose | WMouseNoMask | WStyle_StaysOnTop)
{
  info = new NETWinInfo(tqt_xdisplay(), winId(), tqt_xrootwin(), NET::WMState);
  info->setDesktop(NETWinInfo::OnAllDesktops);

  info->setState(NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager, NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager);
  hide();
  setBackgroundMode(NoBackground);

  KWin::setOnAllDesktops(winId(), true);
  KWin::setState(winId(), NET::SkipTaskbar | NET::SkipPager);
  KWin::setType(winId(), NET::Dock);

  setCaption("kooldock clipping window");
}

clip::~clip()
{
}

void clip::clipDesktop(int p1,int p2,int p3,int p4,int p5,int p6,int p7,int p8,int p9,int p10,int p11,int p12)
{
  KWin::setExtendedStrut(winId(), p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12);
}

void clip::paintEvent(TQPaintEvent*)
{
  TQBitmap bm(size());
  TQPainter mp;
  
  mp.begin(&bm, this);
  mp.fillRect(rect(), TQt::black);
  mp.end();
  setMask(bm);
}
#include "clip.moc"
