#ifndef _KIVIO_1D_STENCIL_H
#define _KIVIO_1D_STENCIL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqdom.h>
#include <tqptrlist.h>

#include <koffice_export.h>

#include "kivio_stencil.h"
#include "kivio_text_style.h"

class KivioArrowHead;
class KivioConnectorPoint;
class KivioCustomDragData;
class KivioFillStyle;
class KivioLineStyle;
class KivioIntraStencilData;
class KivioStencil;


class KIVIO_EXPORT Kivio1DStencil : public KivioStencil
{
protected:
    TQPtrList <KivioConnectorPoint> *m_pConnectorPoints;

    KivioConnectorPoint *m_pStart, *m_pEnd;
    KivioConnectorPoint *m_pLeft, *m_pRight;
    KivioConnectorPoint *m_pTextConn;

    double m_connectorWidth;
    bool m_needsWidth;
    bool m_needsText;

    KivioFillStyle *m_pFillStyle;
    KivioLineStyle *m_pLineStyle;
    KivioTextStyle *m_pTextStyle;

    // Utility routines
    bool boolAllTrue( bool *, int );
    bool boolContainsFalse( bool *, int );

    virtual TQDomElement createRootElement( TQDomDocument & );

    virtual bool saveCustom( TQDomElement &, TQDomDocument & );
    TQDomElement saveConnectors( TQDomDocument &doc );
    TQDomElement saveProperties( TQDomDocument &doc );

    virtual bool loadCustom( const TQDomElement & );
    bool loadConnectors( const TQDomElement & );
    bool loadProperties( const TQDomElement & );

    // For easier duplication
    void copyBasicInto( Kivio1DStencil * );
    void drawText( KivioIntraStencilData * );

public:
    Kivio1DStencil();
    virtual ~Kivio1DStencil();

    virtual bool connected();

    // fg color functions
    virtual void setFGColor( TQColor c );
    virtual TQColor fgColor();


    // bg color functions
    virtual void setBGColor( TQColor c );
    virtual TQColor bgColor();

    virtual void setText( const TQString & t ) { m_pTextStyle->setText(t); }
    virtual TQString text() { return m_pTextStyle->text(); }

    virtual void setTextColor( TQColor c ) { m_pTextStyle->setColor(c); }
    virtual TQColor textColor() { return m_pTextStyle->color(); }

    virtual TQFont textFont() { return m_pTextStyle->font(); }
    virtual void setTextFont( const TQFont &f ) { m_pTextStyle->setFont(f); }

    virtual int hTextAlign() { return m_pTextStyle->hTextAlign(); }
    virtual int vTextAlign() { return m_pTextStyle->vTextAlign(); }

    virtual void setHTextAlign(int i) { m_pTextStyle->setHTextAlign(i); }
    virtual void setVTextAlign(int i) { m_pTextStyle->setVTextAlign(i); }


    // line width functions
    virtual void setLineWidth( double f );
    virtual double lineWidth();

    virtual void setLinePattern(int p);
    virtual int linePattern();

    virtual void setFillPattern(int p);
    virtual int fillPattern();

    // position functions
    virtual void setX( double );
    virtual void setY( double );
    virtual void setPosition( double, double );


    // required for connector tool
    virtual void setStartPoint( double, double );
    virtual void setEndPoint( double, double );


    // painting functions
    virtual void paint( KivioIntraStencilData * );
    virtual void paintOutline( KivioIntraStencilData * );
    virtual void paintConnectorTargets( KivioIntraStencilData * );
    virtual void paintSelectionHandles( KivioIntraStencilData * );


    // collision detection
    virtual KivioCollisionType checkForCollision( KoPoint *, double );


    // custom dragging
    virtual void customDrag( KivioCustomDragData * );


    // geometry management
    virtual void updateGeometry();
    virtual void updateConnectorPoints( KivioConnectorPoint *, double, double );


    // file i/o routines
    virtual bool loadXML( const TQDomElement & );
    virtual TQDomElement saveXML( TQDomDocument & );


    // duplication routines
    virtual KivioStencil* duplicate();


    // connection search routines
    virtual void searchForConnections( KivioPage * );
    virtual void searchForConnections( KivioPage *pPage, double threshold );


    // returns which resize handles are valid
    virtual int resizeHandlePositions();

    virtual void disconnectFromTargets();
    virtual KivioLineStyle lineStyle();
    virtual void setLineStyle(KivioLineStyle ls);

    virtual void setCustomIDPoint(int customID, const KoPoint& point, KivioPage* page);
    virtual KoPoint customIDPoint(int customID);
};


#endif
